/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kieora.backend.lucene;

import java.util.Date;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.kie.kieora.backend.lucene.FieldFactory;
import org.kie.kieora.backend.lucene.LuceneIndexEngine;
import org.kie.kieora.backend.lucene.LuceneSearchIndex;
import org.kie.kieora.backend.lucene.LuceneSetup;
import org.kie.kieora.backend.lucene.fields.SimpleFieldFactory;
import org.kie.kieora.backend.lucene.metamodels.InMemoryMetaModelStore;
import org.kie.kieora.backend.lucene.setups.RAMLuceneSetup;
import org.kie.kieora.engine.MetaModelStore;
import org.kie.kieora.model.KObject;
import org.kie.kieora.model.KProperty;
import org.kie.kieora.model.schema.MetaType;
import org.kie.kieora.search.ClusterSegment;

public class LuceneIndexSearchTest {
    @Test
    public void testSearch() {
        SimpleFieldFactory factory = new SimpleFieldFactory();
        InMemoryMetaModelStore store = new InMemoryMetaModelStore();
        RAMLuceneSetup setup = new RAMLuceneSetup();
        LuceneIndexEngine engine = new LuceneIndexEngine((MetaModelStore)store, (LuceneSetup)setup, (FieldFactory)factory);
        int i = 0;
        while (i < 50) {
            final int index = i++;
            engine.index(new KObject(){

                public String getId() {
                    return "unique.id.here." + index;
                }

                public MetaType getType() {
                    return new MetaType(){

                        public String getName() {
                            return "Path";
                        }
                    };
                }

                public String getClusterId() {
                    return "cluster.id.here." + index % 2;
                }

                public String getSegmentId() {
                    return "/";
                }

                public String getKey() {
                    return "some.key.here." + index;
                }

                public Iterable<KProperty<?>> getProperties() {
                    return new HashSet<KProperty<?>>(){
                        {
                            this.add(new KProperty<String>(){

                                public String getName() {
                                    return "dcore.author";
                                }

                                public String getValue() {
                                    return "Some  Author name Here" + index;
                                }

                                public boolean isSearchable() {
                                    return true;
                                }
                            });
                            this.add(new KProperty<String>(){

                                public String getName() {
                                    return "filename";
                                }

                                public String getValue() {
                                    return "file" + index + ".txt";
                                }

                                public boolean isSearchable() {
                                    return true;
                                }
                            });
                            this.add(new KProperty<String>(){

                                public String getName() {
                                    return "dcore.comment";
                                }

                                public String getValue() {
                                    return "My comment here that has some content that is important to my users." + index;
                                }

                                public boolean isSearchable() {
                                    return true;
                                }
                            });
                            this.add(new KProperty<Integer>(){

                                public String getName() {
                                    return "dcore.review";
                                }

                                public Integer getValue() {
                                    return 10 + index;
                                }

                                public boolean isSearchable() {
                                    return true;
                                }
                            });
                            this.add(new KProperty<Date>(){

                                public String getName() {
                                    return "dcore.lastModifiedTime";
                                }

                                public Date getValue() {
                                    return new Date();
                                }

                                public boolean isSearchable() {
                                    return true;
                                }
                            });
                        }
                    };
                }
            });
        }
        LuceneSearchIndex searchEngine = new LuceneSearchIndex((LuceneSetup)setup);
        Assert.assertEquals((long)1L, (long)searchEngine.fullTextSearchHits("Here49", new ClusterSegment[0]));
        Assert.assertEquals((long)50L, (long)searchEngine.fullTextSearchHits("comment", new ClusterSegment[0]));
        Assert.assertEquals((long)0L, (long)searchEngine.fullTextSearchHits("file.txt", new ClusterSegment[0]));
        Assert.assertEquals((long)1L, (long)searchEngine.fullTextSearchHits("file10", new ClusterSegment[0]));
        Assert.assertEquals((long)1L, (long)searchEngine.fullTextSearchHits("\"file10.txt\"", new ClusterSegment[0]));
        Assert.assertEquals((long)50L, (long)searchEngine.fullTextSearchHits("file10.txt", new ClusterSegment[0]));
        Assert.assertEquals((long)0L, (long)searchEngine.fullTextSearchHits("here49", new ClusterSegment[]{new ClusterSegment(){

            public String getClusterId() {
                return "cluster.id.here.0";
            }

            public String[] segmentIds() {
                return new String[]{"/"};
            }
        }}));
        Assert.assertEquals((long)1L, (long)searchEngine.fullTextSearchHits("here49", new ClusterSegment[]{new ClusterSegment(){

            public String getClusterId() {
                return "cluster.id.here.1";
            }

            public String[] segmentIds() {
                return new String[]{"/"};
            }
        }}));
        Assert.assertEquals((long)25L, (long)searchEngine.fullTextSearchHits("comment", new ClusterSegment[]{new ClusterSegment(){

            public String getClusterId() {
                return "cluster.id.here.1";
            }

            public String[] segmentIds() {
                return new String[]{"/"};
            }
        }}));
        Assert.assertEquals((long)25L, (long)searchEngine.fullTextSearchHits("comment", new ClusterSegment[]{new ClusterSegment(){

            public String getClusterId() {
                return "cluster.id.here.1";
            }

            public String[] segmentIds() {
                return new String[0];
            }
        }}));
        Assert.assertEquals((long)25L, (long)searchEngine.fullTextSearchHits("comment", new ClusterSegment[]{new ClusterSegment(){

            public String getClusterId() {
                return "cluster.id.here.0";
            }

            public String[] segmentIds() {
                return new String[]{"/"};
            }
        }}));
        Assert.assertEquals((long)25L, (long)searchEngine.fullTextSearchHits("comment", new ClusterSegment[]{new ClusterSegment(){

            public String getClusterId() {
                return "cluster.id.here.0";
            }

            public String[] segmentIds() {
                return new String[0];
            }
        }}));
    }
}

