/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kieora.backend.lucene.util;

import org.apache.lucene.document.Document;
import org.kie.kieora.model.KObject;
import org.kie.kieora.model.KProperty;
import org.kie.kieora.model.schema.MetaType;

public final class KObjectUtil {
    public static KObject toKObject(final Document document) {
        return new KObject(){

            public String getId() {
                return document.get("id");
            }

            public MetaType getType() {
                return new MetaType(){

                    public String getName() {
                        return document.get("type");
                    }
                };
            }

            public String getClusterId() {
                return document.get("cluster.id");
            }

            public String getSegmentId() {
                return document.get("segment.id");
            }

            public String getKey() {
                return document.get("key");
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (!(obj instanceof KObject)) {
                    return false;
                }
                KObject kobj = (KObject)obj;
                return this.getClusterId().equals(kobj.getClusterId()) && this.getId().equals(kobj.getId()) && this.getKey().equals(kobj.getKey()) && this.getType().getName().equals(kobj.getType().getName());
            }

            public int hashCode() {
                int result = this.getId().hashCode();
                result = 31 * result + this.getClusterId().hashCode();
                result = 31 * result + this.getKey().hashCode();
                result = 31 * result + this.getType().getName().hashCode();
                return result;
            }

            public Iterable<KProperty<?>> getProperties() {
                return null;
            }
        };
    }
}

