/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kieora.backend.lucene;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.util.Version;
import org.junit.Assert;
import org.junit.Test;
import org.kie.kieora.backend.lucene.setups.BaseLuceneSetup;

public abstract class BaseLuceneSetupTest {
    @Test
    public void test() throws IOException, ParseException {
        BaseLuceneSetup config = this.getLuceneSetup();
        Document doc = new Document();
        String id = "unique.id.here";
        doc.add((IndexableField)new StringField("id", "unique.id.here", Field.Store.YES));
        doc.add((IndexableField)new StringField("type", "kie.Path", Field.Store.YES));
        doc.add((IndexableField)new TextField("content", "some value here that i will query for 1900.", Field.Store.YES));
        config.indexDocument("unique.id.here", doc);
        Assert.assertNotNull((Object)config.nrtSearcher().doc(0));
        config.deleteIfExists(new String[]{"unique.id.here"});
        try {
            config.nrtSearcher().doc(0);
            Assert.fail((String)"can't find doc");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        config.indexDocument("unique.id.here", doc);
        Assert.assertNotNull((Object)config.nrtSearcher().doc(0));
        IndexSearcher searcher = config.nrtSearcher();
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)10, (boolean)true);
        searcher.search((Query)new TermQuery(new Term("content", "value")), (Collector)collector);
        ScoreDoc[] hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)1L, (long)hits.length);
        TopScoreDocCollector collector2 = TopScoreDocCollector.create((int)10, (boolean)true);
        Query q = new QueryParser(Version.LUCENE_40, "content", config.getAnalyzer()).parse("some");
        searcher.search(q, (Collector)collector2);
        ScoreDoc[] hits2 = collector2.topDocs().scoreDocs;
        Assert.assertEquals((long)1L, (long)hits2.length);
    }

    protected abstract BaseLuceneSetup getLuceneSetup();
}

