/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kieora.backend.lucene;

import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.kie.kieora.backend.lucene.FieldFactory;
import org.kie.kieora.backend.lucene.LuceneIndexEngine;
import org.kie.kieora.backend.lucene.LuceneSetup;
import org.kie.kieora.backend.lucene.fields.SimpleFieldFactory;
import org.kie.kieora.engine.MetaModelStore;
import org.kie.kieora.model.KObject;
import org.kie.kieora.model.KProperty;
import org.kie.kieora.model.schema.MetaType;

public abstract class BaseIndexEngineMetaModelTest {
    @Test
    public void testSimpleIndex() throws IOException {
        SimpleFieldFactory factory = new SimpleFieldFactory();
        LuceneIndexEngine engine = new LuceneIndexEngine(this.getMetaModelStore(), this.getLuceneSetup(), (FieldFactory)factory);
        engine.index(new KObject(){

            public String getId() {
                return "unique.id.here";
            }

            public MetaType getType() {
                return new MetaType(){

                    public String getName() {
                        return "Path";
                    }
                };
            }

            public String getClusterId() {
                return "cluster.id.here";
            }

            public String getSegmentId() {
                return "/";
            }

            public String getKey() {
                return "some.key.here";
            }

            public Iterable<KProperty<?>> getProperties() {
                return new HashSet<KProperty<?>>(){
                    {
                        this.add(new KProperty<String>(){

                            public String getName() {
                                return "dcore.author";
                            }

                            public String getValue() {
                                return "Some Author name here.";
                            }

                            public boolean isSearchable() {
                                return true;
                            }
                        });
                        this.add(new KProperty<String>(){

                            public String getName() {
                                return "dcore.comment";
                            }

                            public String getValue() {
                                return "My comment here that has some content that is important to my users.";
                            }

                            public boolean isSearchable() {
                                return true;
                            }
                        });
                    }
                };
            }
        });
        Assert.assertNotNull((Object)this.getMetaModelStore().getMetaObject("Path"));
        Assert.assertNotNull((Object)this.getMetaModelStore().getMetaObject("Path").getProperty("dcore.author"));
        Assert.assertNotNull((Object)this.getMetaModelStore().getMetaObject("Path").getProperty("dcore.comment"));
        Assert.assertNull((Object)this.getMetaModelStore().getMetaObject("Path").getProperty("dcore.review"));
        Assert.assertNull((Object)this.getMetaModelStore().getMetaObject("Path").getProperty("dcore.lastModifiedTime"));
        engine.index(new KObject(){

            public String getId() {
                return "unique.id.here";
            }

            public MetaType getType() {
                return new MetaType(){

                    public String getName() {
                        return "Path";
                    }
                };
            }

            public String getClusterId() {
                return "cluster.id.here";
            }

            public String getSegmentId() {
                return "/";
            }

            public String getKey() {
                return "some.key.here";
            }

            public Iterable<KProperty<?>> getProperties() {
                return new HashSet<KProperty<?>>(){
                    {
                        this.add(new KProperty<String>(){

                            public String getName() {
                                return "dcore.author";
                            }

                            public String getValue() {
                                return "Some Author name here.";
                            }

                            public boolean isSearchable() {
                                return true;
                            }
                        });
                        this.add(new KProperty<String>(){

                            public String getName() {
                                return "dcore.comment";
                            }

                            public String getValue() {
                                return "My comment here that has some content that is important to my users.";
                            }

                            public boolean isSearchable() {
                                return true;
                            }
                        });
                        this.add(new KProperty<Integer>(){

                            public String getName() {
                                return "dcore.review";
                            }

                            public Integer getValue() {
                                return 10;
                            }

                            public boolean isSearchable() {
                                return true;
                            }
                        });
                        this.add(new KProperty<Date>(){

                            public String getName() {
                                return "dcore.lastModifiedTime";
                            }

                            public Date getValue() {
                                return new Date();
                            }

                            public boolean isSearchable() {
                                return true;
                            }
                        });
                    }
                };
            }
        });
        Assert.assertNotNull((Object)this.getMetaModelStore().getMetaObject("Path").getProperty("dcore.author"));
        Assert.assertNotNull((Object)this.getMetaModelStore().getMetaObject("Path").getProperty("dcore.comment"));
        Assert.assertNotNull((Object)this.getMetaModelStore().getMetaObject("Path").getProperty("dcore.review"));
        Assert.assertNotNull((Object)this.getMetaModelStore().getMetaObject("Path").getProperty("dcore.lastModifiedTime"));
        engine.index(new KObject(){

            public String getId() {
                return "some.id.here";
            }

            public MetaType getType() {
                return new MetaType(){

                    public String getName() {
                        return "PathX";
                    }
                };
            }

            public String getClusterId() {
                return "some.cluster.id.here";
            }

            public String getSegmentId() {
                return "/";
            }

            public String getKey() {
                return "some.key.here";
            }

            public Iterable<KProperty<?>> getProperties() {
                return new HashSet<KProperty<?>>(){
                    {
                        this.add(new KProperty<String>(){

                            public String getName() {
                                return "dcore.author";
                            }

                            public String getValue() {
                                return "Some Author name here.";
                            }

                            public boolean isSearchable() {
                                return true;
                            }
                        });
                        this.add(new KProperty<Date>(){

                            public String getName() {
                                return "dcore.lastModifiedTime";
                            }

                            public Date getValue() {
                                return new Date();
                            }

                            public boolean isSearchable() {
                                return true;
                            }
                        });
                    }
                };
            }
        });
        Assert.assertNotNull((Object)this.getMetaModelStore().getMetaObject("Path"));
        Assert.assertNotNull((Object)this.getMetaModelStore().getMetaObject("Path").getProperty("dcore.author"));
        Assert.assertNotNull((Object)this.getMetaModelStore().getMetaObject("Path").getProperty("dcore.comment"));
        Assert.assertNotNull((Object)this.getMetaModelStore().getMetaObject("Path").getProperty("dcore.review"));
        Assert.assertNotNull((Object)this.getMetaModelStore().getMetaObject("Path").getProperty("dcore.lastModifiedTime"));
        Assert.assertNotNull((Object)this.getMetaModelStore().getMetaObject("PathX"));
        Assert.assertNotNull((Object)this.getMetaModelStore().getMetaObject("PathX").getProperty("dcore.author"));
        Assert.assertNotNull((Object)this.getMetaModelStore().getMetaObject("PathX").getProperty("dcore.lastModifiedTime"));
    }

    protected abstract LuceneSetup getLuceneSetup();

    protected abstract MetaModelStore getMetaModelStore();
}

