/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.infinispan;

import java.lang.reflect.Field;
import org.drools.core.command.CommandService;
import org.drools.core.command.impl.AbstractInterceptor;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.runtime.DisposeCommand;
import org.drools.persistence.PersistenceContext;
import org.drools.persistence.PersistenceContextManager;
import org.drools.persistence.SessionMarshallingHelper;
import org.drools.persistence.SingleSessionCommandService;
import org.drools.persistence.info.SessionInfo;
import org.kie.api.command.Command;
import org.kie.api.runtime.KieSession;
import org.kie.internal.command.Context;

public class ManualPersistInterceptor
extends AbstractInterceptor {
    private final SingleSessionCommandService interceptedService;

    public ManualPersistInterceptor(SingleSessionCommandService decorated) {
        this.interceptedService = decorated;
    }

    public <T> T execute(Command<T> command) {
        Object result = this.executeNext(command);
        try {
            KieSession ksession = this.interceptedService.getKieSession();
            Field sessionInfoField = SingleSessionCommandService.class.getDeclaredField("sessionInfo");
            sessionInfoField.setAccessible(true);
            Field jpmField = SingleSessionCommandService.class.getDeclaredField("jpm");
            jpmField.setAccessible(true);
            Object jpm = jpmField.get(this.interceptedService);
            Object sessionInfo = sessionInfoField.get(this.interceptedService);
            if (!(command instanceof DisposeCommand)) {
                this.executeNext((Command)new PersistCommand(sessionInfo, jpm, ksession));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't force persistence of session info", e);
        }
        return (T)result;
    }

    public CommandService getInterceptedService() {
        return this.interceptedService;
    }

    public static class PersistCommand
    implements GenericCommand<Void> {
        private final SessionInfo sessionInfo;
        private final PersistenceContext persistenceContext;
        private final KieSession ksession;

        public PersistCommand(Object sessionInfo, Object jpm, KieSession ksession) {
            this.sessionInfo = (SessionInfo)sessionInfo;
            this.persistenceContext = ((PersistenceContextManager)jpm).getApplicationScopedPersistenceContext();
            this.ksession = ksession;
        }

        public Void execute(Context context) {
            if (this.sessionInfo.getJPASessionMashallingHelper() == null) {
                this.sessionInfo.setJPASessionMashallingHelper(new SessionMarshallingHelper(this.ksession.getKieBase(), this.ksession.getSessionConfiguration(), this.ksession.getEnvironment()));
            }
            this.sessionInfo.transform();
            this.persistenceContext.persist(this.sessionInfo);
            return null;
        }
    }
}

