/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.kie.persistence.session;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.drools.compiler.Person;
import org.drools.core.SessionConfiguration;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.command.impl.FireAllRulesInterceptor;
import org.drools.core.command.impl.LoggingInterceptor;
import org.drools.core.runtime.ChainableRunner;
import org.drools.persistence.PersistableRunner;
import org.drools.persistence.util.PersistenceUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.command.CommandFactory;
import org.kie.internal.persistence.infinispan.InfinispanKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfinispanPersistentStatefulSessionTest {
    private static Logger logger = LoggerFactory.getLogger(InfinispanPersistentStatefulSessionTest.class);
    private HashMap<String, Object> context;
    private Environment env;

    @Before
    public void setUp() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource("drools-configured-cache");
        this.env = PersistenceUtil.createEnvironment(this.context);
    }

    @After
    public void tearDown() throws Exception {
        PersistenceUtil.tearDown(this.context);
    }

    @Test
    public void testFactHandleSerialization() {
        String str = "";
        str = str + "package org.kie.test\n";
        str = str + "import java.util.concurrent.atomic.AtomicInteger\n";
        str = str + "global java.util.List list\n";
        str = str + "rule rule1\n";
        str = str + "when\n";
        str = str + " $i: AtomicInteger(intValue > 0)\n";
        str = str + "then\n";
        str = str + " list.add( $i );\n";
        str = str + "end\n";
        str = str + "\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", str);
        ks.newKieBuilder(kfs).buildAll();
        KieBase kbase = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).getKieBase();
        StatefulKnowledgeSession ksession = InfinispanKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)this.env);
        List list = new ArrayList();
        ksession.setGlobal("list", list);
        AtomicInteger value = new AtomicInteger(4);
        FactHandle atomicFH = ksession.insert((Object)value);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        value.addAndGet(1);
        ksession.update(atomicFH, (Object)value);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        String externalForm = atomicFH.toExternalForm();
        ksession = InfinispanKnowledgeService.loadStatefulKnowledgeSession((long)ksession.getIdentifier(), (KieBase)kbase, null, (Environment)this.env);
        atomicFH = (FactHandle)ksession.execute(CommandFactory.fromExternalFactHandleCommand((String)externalForm));
        value.addAndGet(1);
        ksession.update(atomicFH, (Object)value);
        ksession.fireAllRules();
        list = (List)ksession.getGlobal("list");
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testLocalTransactionPerStatement() {
        String str = "";
        str = str + "package org.kie.test\n";
        str = str + "global java.util.List list\n";
        str = str + "rule rule1\n";
        str = str + "when\n";
        str = str + "  Integer(intValue > 0)\n";
        str = str + "then\n";
        str = str + "  list.add( 1 );\n";
        str = str + "end\n";
        str = str + "\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", str);
        ks.newKieBuilder(kfs).buildAll();
        KieBase kbase = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).getKieBase();
        StatefulKnowledgeSession ksession = InfinispanKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)this.env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ksession.insert((Object)3);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testUserTransactions() throws Exception {
        String str = "";
        str = str + "package org.kie.test\n";
        str = str + "global java.util.List list\n";
        str = str + "rule rule1\n";
        str = str + "when\n";
        str = str + "  $i : Integer(intValue > 0)\n";
        str = str + "then\n";
        str = str + "  list.add( $i );\n";
        str = str + "end\n";
        str = str + "\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", str);
        ks.newKieBuilder(kfs).buildAll();
        KieBase kbase = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).getKieBase();
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        StatefulKnowledgeSession ksession = InfinispanKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)this.env);
        ut.commit();
        ArrayList list = new ArrayList();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ksession.fireAllRules();
        ut.commit();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.insert((Object)3);
        ut.rollback();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.fireAllRules();
        ut.commit();
        Assert.assertEquals((long)2L, (long)list.size());
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.insert((Object)3);
        ksession.insert((Object)4);
        ut.commit();
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)list.size());
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.insert((Object)5);
        ksession.insert((Object)6);
        ut.rollback();
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)list.size());
        ksession = InfinispanKnowledgeService.loadStatefulKnowledgeSession((long)ksession.getIdentifier(), (KieBase)kbase, null, (Environment)this.env);
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.insert((Object)7);
        ksession.insert((Object)8);
        ut.commit();
        ksession.fireAllRules();
        Assert.assertEquals((long)6L, (long)list.size());
    }

    @Test
    public void testInterceptor() {
        String str = "";
        str = str + "package org.kie.test\n";
        str = str + "global java.util.List list\n";
        str = str + "rule rule1\n";
        str = str + "when\n";
        str = str + "  Integer(intValue > 0)\n";
        str = str + "then\n";
        str = str + "  list.add( 1 );\n";
        str = str + "  System.out.println(\"ADDED\");\n";
        str = str + "end\n";
        str = str + "\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", str);
        ks.newKieBuilder(kfs).buildAll();
        KieBase kbase = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).getKieBase();
        StatefulKnowledgeSession ksession = InfinispanKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)this.env);
        PersistableRunner sscs = (PersistableRunner)((CommandBasedStatefulKnowledgeSession)ksession).getRunner();
        sscs.addInterceptor((ChainableRunner)new LoggingInterceptor());
        sscs.addInterceptor((ChainableRunner)new FireAllRulesInterceptor());
        sscs.addInterceptor((ChainableRunner)new LoggingInterceptor());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ksession.insert((Object)3);
        ksession.getWorkItemManager().completeWorkItem(0L, null);
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testSetFocus() {
        String str = "";
        str = str + "package org.kie.test\n";
        str = str + "global java.util.List list\n";
        str = str + "rule rule1\n";
        str = str + "agenda-group \"badfocus\"";
        str = str + "when\n";
        str = str + "  Integer(intValue > 0)\n";
        str = str + "then\n";
        str = str + "  list.add( 1 );\n";
        str = str + "end\n";
        str = str + "\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", str);
        ks.newKieBuilder(kfs).buildAll();
        KieBase kbase = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).getKieBase();
        StatefulKnowledgeSession ksession = InfinispanKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)this.env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ksession.insert((Object)3);
        ksession.getAgenda().getAgendaGroup("badfocus").setFocus();
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testSharedReferences() {
        KieServices ks = KieServices.Factory.get();
        KieBase kbase = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).getKieBase();
        StatefulKnowledgeSession ksession = InfinispanKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)this.env);
        Person x = new Person("test");
        ArrayList<Person> test = new ArrayList<Person>();
        ArrayList<Person> test2 = new ArrayList<Person>();
        test.add(x);
        test2.add(x);
        Assert.assertSame(test.get(0), test2.get(0));
        ksession.insert(test);
        ksession.insert(test2);
        ksession.fireAllRules();
        StatefulKnowledgeSession ksession2 = InfinispanKnowledgeService.loadStatefulKnowledgeSession((long)ksession.getIdentifier(), (KieBase)kbase, null, (Environment)this.env);
        Iterator c = ksession2.getObjects().iterator();
        List ref1 = (List)c.next();
        List ref2 = (List)c.next();
        Assert.assertSame(ref1.get(0), ref2.get(0));
    }

    @Test
    public void testMergeConfig() {
        String str = "";
        str = str + "package org.kie.test\n";
        str = str + "global java.util.List list\n";
        str = str + "rule rule1\n";
        str = str + "when\n";
        str = str + "  $i : Integer(intValue > 0)\n";
        str = str + "then\n";
        str = str + "  list.add( $i );\n";
        str = str + "end\n";
        str = str + "\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", str);
        ks.newKieBuilder(kfs).buildAll();
        KieBase kbase = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).getKieBase();
        Properties properties = new Properties();
        properties.put("drools.processInstanceManagerFactory", "com.example.CustomInfinispanProcessInstanceManagerFactory");
        KieSessionConfiguration config = KnowledgeBaseFactory.newKnowledgeSessionConfiguration((Properties)properties);
        StatefulKnowledgeSession ksession = InfinispanKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, (KieSessionConfiguration)config, (Environment)this.env);
        SessionConfiguration sessionConfig = (SessionConfiguration)ksession.getSessionConfiguration();
        Assert.assertEquals((Object)"com.example.CustomInfinispanProcessInstanceManagerFactory", (Object)sessionConfig.getProcessInstanceManagerFactory());
    }
}

