/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Random;
import org.drools.core.common.DefaultFactHandle;
import org.drools.persistence.api.PersistenceContextManager;
import org.drools.persistence.util.PersistenceUtil;
import org.infinispan.manager.DefaultCacheManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.DefaultAgendaEventListener;
import org.kie.api.event.rule.DefaultRuleRuntimeEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.persistence.infinispan.InfinispanKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class ReloadSessionTest {
    private HashMap<String, Object> context;
    private DefaultCacheManager cm;
    private static String simpleRule = "package org.kie.test\nglobal java.util.List list\nrule rule1\nwhen\n  Integer(intValue > 0)\nthen\n  list.add( 1 );\nend\n\n";

    @Before
    public void setup() {
        this.context = PersistenceUtil.setupWithPoolingDataSource("drools-configured-cache");
        this.cm = (DefaultCacheManager)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
    }

    @After
    public void cleanUp() {
        PersistenceUtil.tearDown(this.context);
    }

    private KnowledgeBase initializeKnowledgeBase(String rule) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    @Test
    public void reloadKnowledgeSessionTest() {
        Environment env = PersistenceUtil.createEnvironment(this.context);
        KnowledgeBase kbase = this.initializeKnowledgeBase(simpleRule);
        StatefulKnowledgeSession commandKSession = InfinispanKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)env);
        Assert.assertTrue((String)"There should be NO facts present in a new (empty) knowledge session.", (boolean)commandKSession.getFactHandles().isEmpty());
        Integer integerFact = new Random().nextInt(0x7FFFFFFE) + 1;
        commandKSession.insert((Object)integerFact);
        Collection factHandles = commandKSession.getFactHandles();
        Assert.assertTrue((String)"At least one fact should have been inserted by the ksession.insert() method above.", (!factHandles.isEmpty() ? 1 : 0) != 0);
        FactHandle origFactHandle = (FactHandle)factHandles.iterator().next();
        Assert.assertTrue((String)"The stored fact should contain the same number as the value inserted (but does not).", (Integer.parseInt(((DefaultFactHandle)origFactHandle).getObject().toString()) == integerFact ? 1 : 0) != 0);
        long sessionInfoId = commandKSession.getIdentifier();
        PersistenceContextManager pcm = (PersistenceContextManager)commandKSession.getEnvironment().get("org.kie.api.persistence.PersistenceContextManager");
        commandKSession.dispose();
        pcm.dispose();
        env = PersistenceUtil.createEnvironment(this.context);
        StatefulKnowledgeSession newCommandKSession = InfinispanKnowledgeService.loadStatefulKnowledgeSession((long)sessionInfoId, (KieBase)kbase, null, (Environment)env);
        factHandles = newCommandKSession.getFactHandles();
        Assert.assertTrue((String)"At least one fact should have been persisted by the ksession.insert above.", (!factHandles.isEmpty() && factHandles.size() == 1 ? 1 : 0) != 0);
        FactHandle retrievedFactHandle = (FactHandle)factHandles.iterator().next();
        Assert.assertTrue((String)"If the retrieved and original FactHandle object are the same, then the knowledge session has NOT been reloaded!", (origFactHandle != retrievedFactHandle ? 1 : 0) != 0);
        Assert.assertTrue((String)"The retrieved fact should contain the same info as the original (but does not).", (Integer.parseInt(((DefaultFactHandle)retrievedFactHandle).getObject().toString()) == integerFact ? 1 : 0) != 0);
        ArrayList list = new ArrayList();
        newCommandKSession.setGlobal("list", list);
        newCommandKSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    @Ignore
    public void testListenersAfterSessionReload() {
        Environment env = PersistenceUtil.createEnvironment(this.context);
        KnowledgeBase kbase = this.initializeKnowledgeBase(simpleRule);
        StatefulKnowledgeSession ksession = InfinispanKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)env);
        ksession.addEventListener((AgendaEventListener)new DefaultAgendaEventListener());
        ksession.addEventListener((RuleRuntimeEventListener)new DefaultRuleRuntimeEventListener());
        Assert.assertEquals((long)1L, (long)ksession.getRuleRuntimeEventListeners().size());
        Assert.assertEquals((long)1L, (long)ksession.getAgendaEventListeners().size());
        ksession = InfinispanKnowledgeService.loadStatefulKnowledgeSession((long)ksession.getIdentifier(), (KieBase)kbase, null, (Environment)env);
        Assert.assertEquals((long)1L, (long)ksession.getRuleRuntimeEventListeners().size());
        Assert.assertEquals((long)1L, (long)ksession.getAgendaEventListeners().size());
    }
}

