/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.util;

import bitronix.tm.BitronixTransactionManager;
import bitronix.tm.TransactionManagerServices;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Properties;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.drools.core.base.MapGlobalResolver;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.infinispan.AdvancedCache;
import org.infinispan.manager.DefaultCacheManager;
import org.junit.Assert;
import org.kie.api.KieBase;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceUtil {
    private static Logger logger = LoggerFactory.getLogger(PersistenceUtil.class);
    private static boolean TEST_MARSHALLING = true;
    public static final String DROOLS_PERSISTENCE_UNIT_NAME = "drools-configured-cache";
    public static final String JBPM_PERSISTENCE_UNIT_NAME = "jbpm-configured-cache";
    protected static final String DATASOURCE_PROPERTIES = "/datasource.properties";
    public static String DATASOURCE = "org.droolsjbpm.persistence.datasource";

    public static HashMap<String, Object> setupWithPoolingDataSource(String persistenceUnitName) {
        return PersistenceUtil.setupWithPoolingDataSource(persistenceUnitName, true);
    }

    public static HashMap<String, Object> setupWithPoolingDataSource(String persistenceUnitName, boolean testMarshalling) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        Properties dsProps = PersistenceUtil.getDatasourceProperties();
        Object testMarshallingProperty = dsProps.get("testMarshalling");
        if ("true".equals(testMarshallingProperty)) {
            TEST_MARSHALLING = true;
            if (!testMarshalling) {
                TEST_MARSHALLING = false;
            }
        } else {
            TEST_MARSHALLING = false;
        }
        if (TEST_MARSHALLING) {
            Class<?> testClass = null;
            StackTraceElement[] ste = Thread.currentThread().getStackTrace();
            int i = 1;
            do {
                try {
                    testClass = Class.forName(ste[i++].getClassName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            } while (PersistenceUtil.class.equals(testClass) && i < ste.length);
            Assert.assertNotNull((String)"Unable to resolve test class!", testClass);
        }
        try {
            DefaultCacheManager cm = new DefaultCacheManager("infinispan.xml");
            AdvancedCache ac = cm.getCache(JBPM_PERSISTENCE_UNIT_NAME).getAdvancedCache();
            if (TEST_MARSHALLING) {
                try {
                    UserTransaction ut = (UserTransaction)ac.getTransactionManager().getTransaction();
                    context.put("org.kie.transaction.Transaction", ut);
                }
                catch (SystemException systemException) {
                    // empty catch block
                }
                context.put("org.kie.transaction.TransactionSynchronizationRegistry", TransactionManagerServices.getTransactionSynchronizationRegistry());
            }
            context.put("org.kie.api.persistence.jpa.EntityManagerFactory", cm);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return context;
    }

    @Deprecated
    public static void tearDown(HashMap<String, Object> context) {
        PersistenceUtil.cleanUp(context);
    }

    public static void cleanUp(HashMap<String, Object> context) {
        if (context != null) {
            Object cmObject;
            BitronixTransactionManager txm = TransactionManagerServices.getTransactionManager();
            if (txm != null) {
                txm.shutdown();
            }
            if ((cmObject = context.remove("org.kie.api.persistence.jpa.EntityManagerFactory")) != null) {
                try {
                    DefaultCacheManager defaultCacheManager = (DefaultCacheManager)cmObject;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public static Properties getDatasourceProperties() {
        String propertiesNotFoundMessage = "Unable to load datasource properties [/datasource.properties]";
        System.setProperty("h2.lobInDatabase", "true");
        InputStream propsInputStream = PersistenceUtil.class.getResourceAsStream(DATASOURCE_PROPERTIES);
        Assert.assertNotNull((String)propertiesNotFoundMessage, (Object)propsInputStream);
        Properties props = new Properties();
        if (propsInputStream != null) {
            try {
                props.load(propsInputStream);
            }
            catch (IOException ioe) {
                logger.warn("Unable to find properties, using default H2 properties: " + ioe.getMessage());
                ioe.printStackTrace();
            }
        }
        return props;
    }

    public static Object getValueOfField(String fieldname, Object source) {
        String sourceClassName = source.getClass().getSimpleName();
        Field field = null;
        try {
            field = source.getClass().getDeclaredField(fieldname);
            field.setAccessible(true);
        }
        catch (SecurityException e) {
            Assert.fail((String)("Unable to retrieve " + fieldname + " field from " + sourceClassName + ": " + e.getCause()));
        }
        catch (NoSuchFieldException e) {
            Assert.fail((String)("Unable to retrieve " + fieldname + " field from " + sourceClassName + ": " + e.getCause()));
        }
        Assert.assertNotNull((String)("." + fieldname + " field is null!?!"), (Object)field);
        Object fieldValue = null;
        try {
            fieldValue = field.get(source);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)("Unable to retrieve value of " + fieldname + " from " + sourceClassName + ": " + e.getCause()));
        }
        catch (IllegalAccessException e) {
            Assert.fail((String)("Unable to retrieve value of " + fieldname + " from " + sourceClassName + ": " + e.getCause()));
        }
        return fieldValue;
    }

    public static Environment createEnvironment(HashMap<String, Object> context) {
        Environment env = EnvironmentFactory.newEnvironment();
        UserTransaction ut = (UserTransaction)context.get("org.kie.transaction.Transaction");
        if (ut != null) {
            env.set("org.kie.transaction.Transaction", (Object)ut);
        }
        env.set("org.kie.api.persistence.jpa.EntityManagerFactory", context.get("org.kie.api.persistence.jpa.EntityManagerFactory"));
        BitronixTransactionManager tm = TransactionManagerServices.getTransactionManager();
        env.set("org.kie.transaction.TransactionManager", (Object)tm);
        env.set("org.kie.Globals", (Object)new MapGlobalResolver());
        return env;
    }

    public static StatefulKnowledgeSession createKnowledgeSessionFromKBase(KieBase kbase, HashMap<String, Object> context) {
        KieSessionConfiguration ksconf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        StatefulKnowledgeSession knowledgeSession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, (KieSessionConfiguration)ksconf, (Environment)PersistenceUtil.createEnvironment(context));
        return knowledgeSession;
    }
}

