/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.jta;

import java.io.Serializable;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.persistence.PersistableRunner;
import org.drools.persistence.infinispan.InfinispanPersistenceContextManager;
import org.drools.persistence.infinispan.marshaller.InfinispanPlaceholderResolverStrategy;
import org.drools.persistence.jta.JtaTransactionManager;
import org.drools.persistence.jta.TransactionTestCommand;
import org.drools.persistence.jta.TransactionTestObject;
import org.drools.persistence.util.PersistenceUtil;
import org.infinispan.Cache;
import org.infinispan.manager.DefaultCacheManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.persistence.infinispan.InfinispanKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JtaTransactionManagerTest {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private HashMap<String, Object> context;
    private DefaultCacheManager cm;
    private static String simpleRule = "package org.kie.test\nglobal java.util.List list\nrule rule1\nwhen\n  Integer(intValue > 0)\nthen\n  list.add( 1 );\nend\n\n";
    public static final String DEFAULT_USER_TRANSACTION_NAME = "java:comp/UserTransaction";
    public static String COMMAND_ENTITY_MANAGER = "drools.persistence.test.command.EntityManager";
    public static String COMMAND_ENTITY_MANAGER_FACTORY = "drools.persistence.test.EntityManagerFactory";
    private static int id = 1;

    @Before
    public void setup() {
        boolean testMarshalling = false;
        this.context = PersistenceUtil.setupWithPoolingDataSource("drools-configured-cache", testMarshalling);
        this.cm = (DefaultCacheManager)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
    }

    @After
    public void tearDown() {
        PersistenceUtil.tearDown(this.context);
    }

    private KieBase initializeKnowledgeBase(String rule) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    protected UserTransaction findUserTransaction() {
        try {
            InitialContext context = new InitialContext();
            return (UserTransaction)context.lookup(DEFAULT_USER_TRANSACTION_NAME);
        }
        catch (NamingException ex) {
            this.logger.debug("No UserTransaction found at JNDI location [{}]", (Object)DEFAULT_USER_TRANSACTION_NAME, (Object)ex);
            return null;
        }
    }

    private String getTestName() {
        StackTraceElement[] ste = Thread.currentThread().getStackTrace();
        String methodName = ste[2].getMethodName();
        return methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
    }

    @Test
    public void basicTransactionManagerTest() {
        String testName = this.getTestName();
        Environment env = PersistenceUtil.createEnvironment(this.context);
        TransactionManager tm = (TransactionManager)env.get("org.kie.transaction.TransactionManager");
        JtaTransactionManager txm = new JtaTransactionManager(env.get("org.kie.transaction.Transaction"), env.get("org.kie.transaction.TransactionSynchronizationRegistry"), (Object)tm);
        TransactionTestObject mainObject = new TransactionTestObject();
        mainObject.setName("main" + testName);
        TransactionTestObject subObject = new TransactionTestObject();
        subObject.setName("sub" + testName);
        mainObject.setSubObject(subObject);
        Cache cache = this.cm.getCache("jbpm-configured-cache");
        try {
            boolean txOwner = txm.begin();
            boolean notTxOwner = txm.begin();
            Serializable s = JtaTransactionManagerTest.generateId(mainObject);
            mainObject.setId(Long.valueOf(s.toString()));
            cache.put((Object)s, (Object)mainObject);
            txm.commit(notTxOwner);
            Serializable s2 = JtaTransactionManagerTest.generateId(subObject);
            subObject.setId(Long.valueOf(s2.toString()));
            cache.put((Object)s2, (Object)subObject);
            txm.commit(txOwner);
        }
        catch (Throwable t) {
            Assert.fail((String)("No exception should have been thrown: " + t.getMessage()));
        }
    }

    @Test
    public void basicTransactionRollbackTest() {
        Environment env = PersistenceUtil.createEnvironment(this.context);
        TransactionManager tm = (TransactionManager)env.get("org.kie.transaction.TransactionManager");
        JtaTransactionManager txm = new JtaTransactionManager(env.get("org.kie.transaction.Transaction"), env.get("org.kie.transaction.TransactionSynchronizationRegistry"), (Object)tm);
        TransactionTestObject mainObject = new TransactionTestObject();
        mainObject.setName("main");
        TransactionTestObject subObject = new TransactionTestObject();
        subObject.setName("sub");
        mainObject.setSubObject(subObject);
        Cache cache = this.cm.getCache("jbpm-configured-cache");
        try {
            boolean notTxOwner = txm.begin();
            Serializable s = JtaTransactionManagerTest.generateId(mainObject);
            mainObject.setId(Long.valueOf(s.toString()));
            cache.put((Object)s, (Object)mainObject);
            txm.rollback(notTxOwner);
        }
        catch (Exception e) {
            Assert.fail((String)("There should not be an exception thrown here: " + e.getMessage()));
        }
    }

    @Test
    public void testSingleSessionCommandServiceAndJtaTransactionManagerTogether() {
        Environment env = PersistenceUtil.createEnvironment(this.context);
        KieBase kbase = this.initializeKnowledgeBase(simpleRule);
        StatefulKnowledgeSession commandKSession = InfinispanKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)env);
        PersistableRunner commandService = (PersistableRunner)((CommandBasedStatefulKnowledgeSession)commandKSession).getRunner();
        InfinispanPersistenceContextManager jpm = (InfinispanPersistenceContextManager)PersistenceUtil.getValueOfField("jpm", commandService);
        jpm.getApplicationScopedPersistenceContext();
        Cache cache = (Cache)PersistenceUtil.getValueOfField("appScopedCache", jpm);
        TransactionTestObject mainObject = new TransactionTestObject();
        mainObject.setName("mainCommand");
        TransactionTestObject subObject = new TransactionTestObject();
        subObject.setName("subCommand");
        mainObject.setSubObject(subObject);
        HashMap<String, Object> emEnv = new HashMap<String, Object>();
        emEnv.put(COMMAND_ENTITY_MANAGER_FACTORY, this.cm);
        emEnv.put(COMMAND_ENTITY_MANAGER, cache);
        TransactionTestCommand txTestCmd = new TransactionTestCommand(mainObject, subObject, emEnv);
        commandKSession.execute((Command)txTestCmd);
    }

    protected static Serializable generateId(TransactionTestObject obj) {
        Serializable serializable;
        Serializable s = InfinispanPlaceholderResolverStrategy.getClassIdValue((Object)obj);
        if (s == null) {
            Integer n = new Integer(++id);
            serializable = n;
        } else {
            serializable = s;
        }
        return serializable;
    }
}

