/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.map.impl;

import java.util.HashMap;
import org.drools.persistence.jpa.marshaller.JPAPlaceholderResolverStrategy;
import org.drools.persistence.jta.JtaTransactionManager;
import org.drools.persistence.map.impl.MapPersistenceTest;
import org.drools.persistence.util.PersistenceUtil;
import org.infinispan.manager.DefaultCacheManager;
import org.junit.After;
import org.junit.Before;
import org.kie.api.KieBase;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.internal.persistence.infinispan.InfinispanKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfinispanBasedPersistenceTest
extends MapPersistenceTest {
    private static Logger logger = LoggerFactory.getLogger(JPAPlaceholderResolverStrategy.class);
    private HashMap<String, Object> context;
    private DefaultCacheManager cm;
    private JtaTransactionManager txm;
    private boolean useTransactions = false;

    @Before
    public void setUp() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource("drools-configured-cache");
        this.cm = (DefaultCacheManager)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        this.txm = (JtaTransactionManager)this.context.get("org.kie.transaction.TransactionManager");
    }

    @After
    public void tearDown() throws Exception {
        PersistenceUtil.tearDown(this.context);
    }

    protected StatefulKnowledgeSession createSession(KieBase kbase) {
        return InfinispanKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)PersistenceUtil.createEnvironment(this.context));
    }

    protected StatefulKnowledgeSession disposeAndReloadSession(KieSession ksession, KieBase kbase) {
        long ksessionId = ksession.getIdentifier();
        ksession.dispose();
        return InfinispanKnowledgeService.loadStatefulKnowledgeSession((long)ksessionId, (KieBase)kbase, null, (Environment)PersistenceUtil.createEnvironment(this.context));
    }

    protected long getSavedSessionsCount() {
        return this.cm.getCache("jbpm-configured-cache").size();
    }
}

