/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.jta;

import bitronix.tm.TransactionManagerServices;
import java.io.Serializable;
import java.util.HashMap;
import org.drools.core.base.MapGlobalResolver;
import org.drools.core.command.impl.RegistryContext;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.persistence.infinispan.marshaller.InfinispanPlaceholderResolverStrategy;
import org.drools.persistence.jta.JtaTransactionManagerTest;
import org.drools.persistence.jta.TransactionTestObject;
import org.infinispan.Cache;
import org.infinispan.manager.DefaultCacheManager;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.internal.persistence.infinispan.InfinispanKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class TransactionTestCommand
implements ExecutableCommand<Void> {
    private static final long serialVersionUID = -7640078670024414748L;
    private Object mainObject;
    private Object subObject;
    private Cache<Serializable, Object> cache;
    private DefaultCacheManager cm;
    private static long value = 1L;

    public TransactionTestCommand(Object mainObject, Object subObject, HashMap<String, Object> env) {
        this.mainObject = mainObject;
        this.subObject = subObject;
        this.setPersistenceFields(env);
    }

    public TransactionTestCommand(Object mainObject, HashMap<String, Object> env) {
        this.mainObject = mainObject;
        this.subObject = null;
        this.setPersistenceFields(env);
    }

    private void setPersistenceFields(HashMap<String, Object> env) {
        this.cache = (Cache)env.get(JtaTransactionManagerTest.COMMAND_ENTITY_MANAGER);
        this.cm = (DefaultCacheManager)env.get(JtaTransactionManagerTest.COMMAND_ENTITY_MANAGER_FACTORY);
    }

    private HashMap<String, Object> getPersistenceEnvironment() {
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put(JtaTransactionManagerTest.COMMAND_ENTITY_MANAGER, this.cache);
        env.put(JtaTransactionManagerTest.COMMAND_ENTITY_MANAGER_FACTORY, this.cm);
        return env;
    }

    public Void execute(Context context) {
        TransactionTestObject obj = (TransactionTestObject)this.mainObject;
        if (obj.getId() == null) {
            obj.setId(TransactionTestCommand.generateId());
        }
        this.cache.put((Object)InfinispanPlaceholderResolverStrategy.getClassIdValue((Object)this.mainObject), this.mainObject);
        if (this.subObject != null) {
            KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
            InternalKnowledgeBase cleanKBase = KnowledgeBaseFactory.newKnowledgeBase();
            cleanKBase.addPackages(((InternalKnowledgeBase)ksession.getKieBase()).getKiePackages());
            StatefulKnowledgeSession commandKSession = InfinispanKnowledgeService.newStatefulKnowledgeSession((KieBase)cleanKBase, null, (Environment)this.initializeEnvironment());
            TransactionTestCommand transactionTestSubCommand = new TransactionTestCommand(this.subObject, this.getPersistenceEnvironment());
            commandKSession.execute((Command)transactionTestSubCommand);
        }
        return null;
    }

    private static Long generateId() {
        return ++value;
    }

    private Environment initializeEnvironment() {
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("org.kie.api.persistence.jpa.EntityManagerFactory", (Object)this.cm);
        env.set("org.kie.Globals", (Object)new MapGlobalResolver());
        env.set("org.kie.transaction.TransactionManager", (Object)TransactionManagerServices.getTransactionManager());
        return env;
    }
}

