/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.runtimemanager.api.utils;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;
import org.kie.efesto.common.api.io.IndexFile;
import org.kie.efesto.common.api.model.FRI;
import org.kie.efesto.runtimemanager.api.utils.GeneratedResourceUtils;

class GeneratedResourceUtilsTest {
    GeneratedResourceUtilsTest() {
    }

    @Test
    void getGeneratedExecutableResource() {
        FRI fri = new FRI("testmod", "test");
        Optional retrieved = GeneratedResourceUtils.getGeneratedExecutableResource((FRI)fri, (String)"test");
        ((OptionalAssert)Assertions.assertThat((Optional)retrieved).isNotNull()).isPresent();
        fri = new FRI("notestmod", "test");
        retrieved = GeneratedResourceUtils.getGeneratedExecutableResource((FRI)fri, (String)"test");
        ((OptionalAssert)Assertions.assertThat((Optional)retrieved).isNotNull()).isNotPresent();
    }

    @Test
    void getGeneratedRedirectResourceFromFile() {
        FRI fri = new FRI("redirecttestmod", "test");
        Optional retrieved = GeneratedResourceUtils.getGeneratedRedirectResource((FRI)fri, (String)"test");
        ((OptionalAssert)Assertions.assertThat((Optional)retrieved).isNotNull()).isPresent();
        fri = new FRI("redirectnotestmod", "test");
        retrieved = GeneratedResourceUtils.getGeneratedRedirectResource((FRI)fri, (String)"test");
        ((OptionalAssert)Assertions.assertThat((Optional)retrieved).isNotNull()).isNotPresent();
    }

    @Test
    void getGeneratedRedirectResourceFromJar() {
        ClassLoader originalClassLoader = this.addJarToClassLoader();
        FRI fri = new FRI("redirecttestmod", "testb");
        Optional retrieved = GeneratedResourceUtils.getGeneratedRedirectResource((FRI)fri, (String)"testb");
        ((OptionalAssert)Assertions.assertThat((Optional)retrieved).isNotNull()).isPresent();
        fri = new FRI("redirectnotestmod", "testb");
        retrieved = GeneratedResourceUtils.getGeneratedRedirectResource((FRI)fri, (String)"testb");
        ((OptionalAssert)Assertions.assertThat((Optional)retrieved).isNotNull()).isNotPresent();
        this.restoreClassLoader(originalClassLoader);
    }

    @Test
    void getIndexFileFromFile() {
        Optional retrieved = GeneratedResourceUtils.getIndexFile((String)"test");
        ((OptionalAssert)Assertions.assertThat((Optional)retrieved).isNotNull()).isPresent();
    }

    @Test
    void getIndexFileFromJar() {
        ClassLoader originalClassLoader = this.addJarToClassLoader();
        Optional retrieved = GeneratedResourceUtils.getIndexFile((String)"testb");
        ((OptionalAssert)Assertions.assertThat((Optional)retrieved).isNotNull()).isPresent();
        IndexFile indexFile = (IndexFile)retrieved.get();
        Assertions.assertThat((long)indexFile.length()).isGreaterThan(0L);
        this.restoreClassLoader(originalClassLoader);
    }

    private ClassLoader addJarToClassLoader() {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        URL jarUrl = Thread.currentThread().getContextClassLoader().getResource("TestJar.jar");
        Assertions.assertThat((URL)jarUrl).isNotNull();
        URL fileUrl = Thread.currentThread().getContextClassLoader().getResource("IndexFile.testb_json");
        Assertions.assertThat((URL)fileUrl).isNull();
        URL[] urls = new URL[]{jarUrl};
        URLClassLoader testClassLoader = URLClassLoader.newInstance(urls, originalClassLoader);
        Thread.currentThread().setContextClassLoader(testClassLoader);
        return originalClassLoader;
    }

    private void restoreClassLoader(ClassLoader toRestore) {
        Thread.currentThread().setContextClassLoader(toRestore);
    }
}

