/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.prediction.pmml;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.jbpm.prediction.pmml.PMMLRandomForest;
import org.kie.internal.task.api.prediction.PredictionService;

public class PMMLRandomForestRegistry {
    private static final ServiceLoader<PredictionService> foundServices = ServiceLoader.load(PredictionService.class, PMMLRandomForestRegistry.class.getClassLoader());
    private String selectedService = System.getProperty("org.jbpm.prediction.pmml", "PMMLRandomForest");
    private Map<String, PredictionService> predictionServices = new HashMap<String, PredictionService>();

    private PMMLRandomForestRegistry() {
        foundServices.forEach(strategy -> this.predictionServices.put(strategy.getIdentifier(), (PredictionService)strategy));
    }

    public static PMMLRandomForestRegistry get() {
        return Holder.INSTANCE;
    }

    public PredictionService getService() {
        PredictionService predictionService = this.predictionServices.get(this.selectedService);
        if (predictionService == null) {
            throw new IllegalArgumentException("No prediction service was found with id " + this.selectedService);
        }
        return predictionService;
    }

    public synchronized void addStrategy(PMMLRandomForest predictionService) {
        this.predictionServices.put(predictionService.getIdentifier(), predictionService);
    }

    private static class Holder {
        static final PMMLRandomForestRegistry INSTANCE = new PMMLRandomForestRegistry();

        private Holder() {
        }
    }
}

