/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.springboot.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.kie.internal.identity.IdentityProvider;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.provisioning.UserDetailsManager;

public class SpringSecurityIdentityProvider
implements IdentityProvider {
    private Stack<String> contextUsers;
    private ApplicationContext context;

    public SpringSecurityIdentityProvider(ApplicationContext context) {
        this.context = context;
        this.contextUsers = new Stack();
    }

    public void setContextIdentity(String userId) {
        this.contextUsers.push(userId);
    }

    public void removeContextIdentity() {
        this.contextUsers.pop();
    }

    public String getName() {
        if (!this.contextUsers.isEmpty()) {
            return this.contextUsers.peek();
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null && auth.isAuthenticated()) {
            return auth.getName();
        }
        return "unknown";
    }

    public List<String> getRolesFor(String userId) {
        if (this.getName().equals(userId)) {
            return this.getRoles();
        }
        try {
            UserDetailsManager manager = (UserDetailsManager)this.context.getBean(UserDetailsManager.class);
            UserDetails userDetails = manager.loadUserByUsername(userId);
            return this.toRoles(userDetails.getAuthorities());
        }
        catch (NoSuchBeanDefinitionException | UsernameNotFoundException e) {
            return Collections.emptyList();
        }
    }

    public List<String> getRoles() {
        if (!this.contextUsers.isEmpty()) {
            return this.getRolesFor(this.contextUsers.peek());
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null && auth.isAuthenticated()) {
            return this.toRoles(auth.getAuthorities());
        }
        return Collections.emptyList();
    }

    private List<String> toRoles(Collection<? extends GrantedAuthority> authorities) {
        ArrayList<String> roles = new ArrayList<String>();
        for (GrantedAuthority grantedAuthority : authorities) {
            String roleName = grantedAuthority.getAuthority();
            if (roleName.startsWith("ROLE_")) {
                roleName = roleName.replaceFirst("ROLE_", "");
            }
            roles.add(roleName);
        }
        return roles;
    }

    public boolean hasRole(String role) {
        return false;
    }
}

