/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.springboot.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kie.internal.identity.IdentityProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class SpringSecurityIdentityProvider
implements IdentityProvider {
    public String getName() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null && auth.isAuthenticated()) {
            return auth.getName();
        }
        return "system";
    }

    public List<String> getRoles() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null && auth.isAuthenticated()) {
            ArrayList<String> roles = new ArrayList<String>();
            for (GrantedAuthority ga : auth.getAuthorities()) {
                String roleName = ga.getAuthority();
                if (roleName.startsWith("ROLE_")) {
                    roleName = roleName.replaceFirst("ROLE_", "");
                }
                roles.add(roleName);
            }
            return roles;
        }
        return Collections.emptyList();
    }

    public boolean hasRole(String role) {
        return false;
    }
}

