/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.springboot.datasources;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.bind.RelaxedDataBinder;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.boot.jta.XADataSourceWrapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={XADataSource.class})
public class JBPMDataSourceAutoConfiguration {
    private XADataSource xaDataSource;
    private XADataSourceWrapper wrapper;

    public JBPMDataSourceAutoConfiguration(XADataSourceWrapper wrapper) {
        this.wrapper = wrapper;
    }

    @Bean
    @Primary
    @ConfigurationProperties(value="spring.datasource")
    public DataSourceProperties dataSourceProperties() {
        return new DataSourceProperties();
    }

    @Bean
    @Primary
    @ConfigurationProperties(value="spring.datasource")
    public DataSource dataSource() throws Exception {
        this.xaDataSource = this.createXaDataSource();
        return this.wrapper.wrapDataSource(this.xaDataSource);
    }

    @Bean
    @ConditionalOnMissingBean(name={"quartzDataSource"})
    @ConditionalOnProperty(name={"jbpm.quartz.enabled", "jbpm.quartz.db"}, havingValue="true")
    public DataSource quartzDataSource(DataSource dataSource) {
        return dataSource;
    }

    @Bean
    @ConditionalOnMissingBean(name={"quartzDatasourceProperties"})
    @ConfigurationProperties(value="quartz.datasource")
    public DataSourceProperties quartzDatasourceProperties() {
        return new DataSourceProperties();
    }

    @Bean
    @ConditionalOnMissingBean(name={"quartzPoolProperties"})
    @ConfigurationProperties(value="quartz.datasource.dbcp2")
    public Map<String, Object> quartzPoolProperties() {
        return new HashMap<String, Object>();
    }

    @Bean
    @ConditionalOnMissingBean(name={"quartzNotManagedDataSource"})
    @ConditionalOnProperty(name={"jbpm.quartz.enabled", "jbpm.quartz.db"}, havingValue="true")
    public DataSource quartzNotManagedDataSource() {
        DataSource ds = this.quartzDatasourceProperties().initializeDataSourceBuilder().build();
        Map<String, Object> poolProperties = this.quartzPoolProperties();
        MutablePropertyValues properties = new MutablePropertyValues(poolProperties);
        new RelaxedDataBinder((Object)ds).bind((PropertyValues)properties);
        return ds;
    }

    private XADataSource createXaDataSource() {
        DataSourceProperties dataSourceProperties = this.dataSourceProperties();
        String className = dataSourceProperties.getXa().getDataSourceClassName();
        if (!StringUtils.hasLength((String)className)) {
            className = DatabaseDriver.fromJdbcUrl((String)dataSourceProperties.determineUrl()).getXaDataSourceClassName();
        }
        Assert.state((boolean)StringUtils.hasLength((String)className), (String)"No XA DataSource class name specified");
        XADataSource dataSource = this.createXaDataSourceInstance(className);
        this.bindXaProperties(dataSource, dataSourceProperties);
        return dataSource;
    }

    private XADataSource createXaDataSourceInstance(String className) {
        try {
            Class dataSourceClass = ClassUtils.forName((String)className, (ClassLoader)this.getClass().getClassLoader());
            Object instance = BeanUtils.instantiate((Class)dataSourceClass);
            Assert.isInstanceOf(XADataSource.class, (Object)instance);
            return (XADataSource)instance;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to create XADataSource instance from '" + className + "'", ex);
        }
    }

    private void bindXaProperties(XADataSource target, DataSourceProperties properties) {
        MutablePropertyValues values = new MutablePropertyValues();
        values.add("user", (Object)properties.determineUsername());
        values.add("password", (Object)properties.determinePassword());
        values.add("url", (Object)properties.determineUrl());
        values.addPropertyValues(properties.getXa().getProperties());
        new RelaxedDataBinder((Object)target).withAlias("user", new String[]{"username"}).bind((PropertyValues)values);
    }
}

