/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.springboot.samples;

import java.io.File;
import java.util.HashMap;
import org.appformer.maven.integration.MavenRepository;
import org.appformer.maven.support.AFReleaseId;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.admin.MigrationReport;
import org.jbpm.services.api.admin.ProcessInstanceMigrationService;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.springboot.samples.JBPMApplication;
import org.jbpm.springboot.samples.TestAutoConfiguration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.process.ProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@SpringBootTest(classes={JBPMApplication.class, TestAutoConfiguration.class}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@TestPropertySource(locations={"classpath:application-test.properties"})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_CLASS)
public class MigrationProcessTest {
    static final String ARTIFACT_ID = "evaluation";
    static final String GROUP_ID = "org.jbpm.test";
    static final String VERSION = "1.0.0";
    static final String VERSION_2 = "1.0.1";
    private KModuleDeploymentUnit unit = null;
    private KModuleDeploymentUnit unitV2 = null;
    @Autowired
    private ProcessService processService;
    @Autowired
    private DeploymentService deploymentService;
    @Autowired
    private ProcessInstanceMigrationService processInstanceMigrationService;
    @Autowired
    private RuntimeDataService runtimeDataService;

    @BeforeClass
    public static void generalSetup() {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION);
        File kjar = new File("../kjars/evaluation/jbpm-module.jar");
        File pom = new File("../kjars/evaluation/pom.xml");
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.installArtifact((AFReleaseId)releaseId, kjar, pom);
        ReleaseId releaseId2 = ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION_2);
        File kjar2 = new File("../kjars/evaluation/jbpm-module.jar");
        File pom2 = new File("../kjars/evaluation/pom2.xml");
        repository.installArtifact((AFReleaseId)releaseId2, kjar2, pom2);
        EntityManagerFactoryManager.get().clear();
    }

    @Before
    public void setup() {
        this.unit = new KModuleDeploymentUnit(GROUP_ID, ARTIFACT_ID, VERSION);
        this.deploymentService.deploy((DeploymentUnit)this.unit);
        this.unitV2 = new KModuleDeploymentUnit(GROUP_ID, ARTIFACT_ID, VERSION_2);
        this.deploymentService.deploy((DeploymentUnit)this.unitV2);
    }

    @After
    public void cleanup() {
        this.deploymentService.undeploy((DeploymentUnit)this.unit);
        this.deploymentService.undeploy((DeploymentUnit)this.unitV2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProcessStartAndAbort() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("employee", "john");
        parameters.put("reason", "SpringBoot jBPM evaluation");
        long processInstanceId = this.processService.startProcess(this.unit.getIdentifier(), ARTIFACT_ID);
        Assert.assertNotNull((Object)processInstanceId);
        Assert.assertTrue((processInstanceId > 0L ? 1 : 0) != 0);
        try {
            ProcessInstanceDesc piLog = this.runtimeDataService.getProcessInstanceById(processInstanceId);
            Assert.assertNotNull((Object)piLog);
            Assert.assertEquals((Object)this.unit.getIdentifier(), (Object)piLog.getDeploymentId());
            MigrationReport report = this.processInstanceMigrationService.migrate(this.unit.getIdentifier(), Long.valueOf(processInstanceId), this.unitV2.getIdentifier(), ARTIFACT_ID);
            Assert.assertTrue((boolean)report.isSuccessful());
            piLog = this.runtimeDataService.getProcessInstanceById(processInstanceId);
            Assert.assertNotNull((Object)piLog);
            Assert.assertEquals((Object)this.unitV2.getIdentifier(), (Object)piLog.getDeploymentId());
        }
        finally {
            this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
            ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
            Assert.assertNull((Object)pi);
        }
    }
}

