/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.springboot.samples;

import java.io.File;
import java.util.Collection;
import org.appformer.maven.integration.MavenRepository;
import org.appformer.maven.support.AFReleaseId;
import org.drools.persistence.jpa.processinstance.JPAWorkItemManager;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.springboot.samples.JBPMApplication;
import org.jbpm.springboot.samples.TestAutoConfiguration;
import org.jbpm.springboot.samples.handlers.CustomWorkItemHandler;
import org.jbpm.springboot.samples.handlers.LogWorkItemHandler;
import org.jbpm.springboot.samples.handlers.WidWorkItemHandler;
import org.jbpm.springboot.samples.listeners.CustomProcessEventListener;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.command.RegistryContext;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@SpringBootTest(classes={JBPMApplication.class, TestAutoConfiguration.class}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@TestPropertySource(locations={"classpath:application-test.properties"})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_CLASS)
public class ConfigurationTest {
    static final String ARTIFACT_ID = "evaluation";
    static final String GROUP_ID = "org.jbpm.test";
    static final String VERSION = "1.0.0";
    private KModuleDeploymentUnit unit = null;
    @Autowired
    private DeploymentService deploymentService;

    @BeforeClass
    public static void generalSetup() {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION);
        File kjar = new File("../kjars/evaluation/jbpm-module.jar");
        File pom = new File("../kjars/evaluation/pom.xml");
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.installArtifact((AFReleaseId)releaseId, kjar, pom);
        EntityManagerFactoryManager.get().clear();
    }

    @Before
    public void setup() {
        this.unit = new KModuleDeploymentUnit(GROUP_ID, ARTIFACT_ID, VERSION);
        this.deploymentService.deploy((DeploymentUnit)this.unit);
    }

    @After
    public void cleanup() {
        this.deploymentService.undeploy((DeploymentUnit)this.unit);
    }

    @Test
    public void testWorkItemHandlerRegistration() {
        Assert.assertNotNull((Object)this.unit);
        RuntimeManager runtimeManager = RuntimeManagerRegistry.get().getManager(this.unit.getIdentifier());
        Assert.assertNotNull((String)"Runtime manager is missing for deployed kjar", (Object)runtimeManager);
        RuntimeEngine engine = runtimeManager.getRuntimeEngine(EmptyContext.get());
        WorkItemManager manager = (WorkItemManager)engine.getKieSession().execute((Command)new ExecutableCommand<WorkItemManager>(){
            private static final long serialVersionUID = 8170184822180761325L;

            public WorkItemManager execute(Context context) {
                KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
                return ksession.getWorkItemManager();
            }
        });
        Assert.assertNotNull((Object)manager);
        Assert.assertTrue((boolean)(manager instanceof JPAWorkItemManager));
        WorkItemHandler handler = ((JPAWorkItemManager)manager).getWorkItemHandler("Custom");
        Assert.assertNotNull((Object)handler);
        Assert.assertTrue((boolean)(handler instanceof CustomWorkItemHandler));
        handler = ((JPAWorkItemManager)manager).getWorkItemHandler("WidCustom");
        Assert.assertNotNull((Object)handler);
        Assert.assertTrue((boolean)(handler instanceof WidWorkItemHandler));
        handler = ((JPAWorkItemManager)manager).getWorkItemHandler("Log");
        Assert.assertNotNull((Object)handler);
        Assert.assertTrue((boolean)(handler instanceof LogWorkItemHandler));
        runtimeManager.disposeRuntimeEngine(engine);
    }

    @Test
    public void testProcessEventListenerRegistration() {
        Assert.assertNotNull((Object)this.unit);
        RuntimeManager runtimeManager = RuntimeManagerRegistry.get().getManager(this.unit.getIdentifier());
        Assert.assertNotNull((String)"Runtime manager is missing for deployed kjar", (Object)runtimeManager);
        RuntimeEngine engine = runtimeManager.getRuntimeEngine(EmptyContext.get());
        Collection pListeners = engine.getKieSession().getProcessEventListeners();
        Assert.assertNotNull((Object)pListeners);
        Assert.assertTrue((boolean)pListeners.stream().anyMatch(listener -> listener instanceof CustomProcessEventListener));
        runtimeManager.disposeRuntimeEngine(engine);
    }
}

