/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.springboot.samples;

import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.jbpm.springboot.samples.handlers.WidWorkItemHandler;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.identity.IdentityProvider;
import org.springframework.context.annotation.Bean;

public class TestAutoConfiguration {
    @Bean
    public IdentityProvider identityProvider() {
        return new IdentityProvider(){
            private Stack<String> contextUsers = new Stack();
            private List<String> roles = Arrays.asList("PM", "HR");

            public void setContextIdentity(String userId) {
                this.contextUsers.push(userId);
            }

            public void removeContextIdentity() {
                this.contextUsers.pop();
            }

            public boolean hasRole(String arg0) {
                return this.roles.contains(arg0);
            }

            public List<String> getRoles() {
                return this.roles;
            }

            public String getName() {
                if (!this.contextUsers.isEmpty()) {
                    return this.contextUsers.peek();
                }
                return "john";
            }
        };
    }

    @Bean
    public WorkItemHandler customWidHandler() {
        return new WidWorkItemHandler();
    }
}

