/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.springboot.samples;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.appformer.maven.integration.MavenRepository;
import org.appformer.maven.support.AFReleaseId;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.springboot.samples.JBPMApplication;
import org.jbpm.springboot.samples.TestAutoConfiguration;
import org.jbpm.springboot.samples.events.listeners.CountDownLatchEventListener;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.process.ProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@SpringBootTest(classes={JBPMApplication.class, TestAutoConfiguration.class}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@TestPropertySource(locations={"classpath:application-quartz.properties"})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_CLASS)
public class JMXQuartzSchedulerTest {
    private static final String GROUP_ID = "org.jbpm";
    private static final String ARTIFACT_ID = "intermediate-timer-sample";
    private static final String VERSION = "1.0";
    private static final String PROCESS_ID = "org.jbpm.sample.intermediate-timer";
    private static final String EVENT_NODE_NAME = "Intermediate Catch Event 1";
    private KModuleDeploymentUnit unit = null;
    private MBeanServer mBeanServer = null;
    private ObjectName oName = null;
    @Autowired
    private ProcessService processService;
    @Autowired
    private DeploymentService deploymentService;
    @Autowired
    private CountDownLatchEventListener countDownListener;

    @BeforeClass
    public static void generalSetup() {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION);
        File kjar = new File("../kjars/intermediate-timer-sample/intermediate-timer-sample-1.0.jar");
        File pom = new File("../kjars/intermediate-timer-sample/pom.xml");
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.installArtifact((AFReleaseId)releaseId, kjar, pom);
    }

    @Before
    public void setup() {
        this.unit = new KModuleDeploymentUnit(GROUP_ID, ARTIFACT_ID, VERSION);
        this.deploymentService.deploy((DeploymentUnit)this.unit);
        this.countDownListener.configure(PROCESS_ID, 1);
    }

    @After
    public void cleanup() {
        this.deploymentService.undeploy((DeploymentUnit)this.unit);
    }

    @Test(timeout=30000L)
    public void whenSchedulerStartedThenTimerIsFired() throws Exception {
        Long processInstanceId = this.processService.startProcess(this.unit.getIdentifier(), PROCESS_ID);
        Assert.assertNotNull((Object)processInstanceId);
        this.countDownListener.getCountDown().await();
        Assert.assertTrue((boolean)this.countDownListener.getExecutingThread().startsWith("SpringBootScheduler"));
        ProcessInstance pi = this.processService.getProcessInstance(processInstanceId);
        Assert.assertNull((Object)pi);
    }

    @Test(timeout=30000L)
    public void whenSchedulerPausedThenTimerNotFired() throws Exception {
        Long processInstanceId = this.processService.startProcess(this.unit.getIdentifier(), PROCESS_ID);
        Assert.assertNotNull((Object)processInstanceId);
        this.pauseScheduler();
        this.awaitWithoutInterruption();
        ProcessInstance pi = this.processService.getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstanceId);
        Assert.assertEquals((long)1L, (long)pi.getState());
        this.processService.abortProcessInstance(processInstanceId);
    }

    @Test(timeout=40000L)
    public void whenSchedulerRestartedThenTimerIsFired() throws Exception {
        Long processInstanceId = this.processService.startProcess(this.unit.getIdentifier(), PROCESS_ID);
        Assert.assertNotNull((Object)processInstanceId);
        this.pauseScheduler();
        this.awaitWithoutInterruption();
        this.restartScheduler();
        this.countDownListener.getCountDown().await();
        Assert.assertTrue((boolean)this.countDownListener.getExecutingThread().startsWith("SpringBootScheduler"));
        ProcessInstance pi = this.processService.getProcessInstance(processInstanceId);
        Assert.assertNull((Object)pi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testTimerName() throws Exception {
        Long processInstanceId = this.processService.startProcess(this.unit.getIdentifier(), PROCESS_ID);
        Assert.assertNotNull((Object)processInstanceId);
        try {
            this.findTargetObjectName();
            List jobGroupNames = (List)this.mBeanServer.getAttribute(this.oName, "JobGroupNames");
            Assert.assertEquals((String)"There should be just only one job group name", (long)1L, (long)jobGroupNames.size());
            Assert.assertEquals((String)"jobGroupName must be the deployment unit id", (Object)this.unit.getIdentifier(), jobGroupNames.get(0));
            List jobNames = (List)this.mBeanServer.invoke(this.oName, "getJobNames", new String[]{(String)jobGroupNames.get(0)}, new String[]{"java.lang.String"});
            Assert.assertEquals((String)"There should be just only one job name", (long)1L, (long)jobNames.size());
            String jobName = (String)jobNames.get(0);
            Assert.assertTrue((String)String.format("jobName '%s' must contain the node name '%s'", jobName, EVENT_NODE_NAME), (boolean)jobName.contains(EVENT_NODE_NAME));
        }
        finally {
            this.processService.abortProcessInstance(processInstanceId);
        }
    }

    private void awaitWithoutInterruption() throws InterruptedException {
        boolean await = this.countDownListener.getCountDown().await(20L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)await);
    }

    private void pauseScheduler() throws Exception {
        this.findTargetObjectName();
        this.waitUntilSchedulerStarted();
        this.mBeanServer.invoke(this.oName, "standby", null, null);
        Assert.assertFalse((String)"There should be Started attribute set to false", (boolean)((Boolean)this.mBeanServer.getAttribute(this.oName, "Started")));
        Assert.assertTrue((String)"There should be StandbyMode attribute set to true", (boolean)((Boolean)this.mBeanServer.getAttribute(this.oName, "StandbyMode")));
    }

    private void restartScheduler() throws Exception {
        this.mBeanServer.invoke(this.oName, "start", null, null);
        Assert.assertTrue((String)"There should be Started attribute set to true", (boolean)((Boolean)this.mBeanServer.getAttribute(this.oName, "Started")));
        Assert.assertFalse((String)"There should be StandbyMode attribute set to false", (boolean)((Boolean)this.mBeanServer.getAttribute(this.oName, "StandbyMode")));
    }

    private void findTargetObjectName() throws MalformedObjectNameException {
        this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> objectNames = this.mBeanServer.queryNames(new ObjectName("quartz:type=QuartzScheduler,name=*,instance=*"), null);
        Assert.assertFalse((String)"There should be a quartz scheduler MBean", (boolean)objectNames.isEmpty());
        this.oName = (ObjectName)objectNames.stream().findFirst().get();
    }

    private void waitUntilSchedulerStarted() {
        BooleanSupplier schedulerStarted = () -> {
            try {
                return (Boolean)this.mBeanServer.getAttribute(this.oName, "Started");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        JMXQuartzSchedulerTest.wait(Duration.of(30L, ChronoUnit.SECONDS), Duration.of(1L, ChronoUnit.SECONDS), schedulerStarted);
    }

    private static void wait(Duration maxDuration, Duration waitStep, BooleanSupplier booleanSupplier) {
        Instant startTime = Instant.now();
        while (startTime.plus(maxDuration).isAfter(Instant.now()) && !booleanSupplier.getAsBoolean()) {
            JMXQuartzSchedulerTest.wait(waitStep);
        }
    }

    private static void wait(Duration duration) {
        try {
            Thread.sleep(duration.toMillis());
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Waiting was interrupted", e);
        }
    }
}

