/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.springboot.samples;

import java.io.File;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.appformer.maven.integration.MavenRepository;
import org.appformer.maven.support.AFReleaseId;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.springboot.samples.ExtendedEntityManagerFactory;
import org.jbpm.springboot.samples.JBPMApplication;
import org.jbpm.springboot.samples.entities.Person;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@SpringBootTest(classes={JBPMApplication.class, ExtendedEntityManagerFactory.class}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@TestPropertySource(locations={"classpath:application-test.properties"})
public class ExtendedEMFBusinessProcessTest {
    static final String ARTIFACT_ID = "evaluation";
    static final String GROUP_ID = "org.jbpm.test";
    static final String VERSION = "1.0.0";
    private KModuleDeploymentUnit unit = null;
    @Autowired
    private ProcessService processService;
    @Autowired
    private DeploymentService deploymentService;
    @Autowired
    private EntityManagerFactory entityManagerFactory;

    @BeforeClass
    public static void generalSetup() {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION);
        File kjar = new File("../kjars/evaluation/jbpm-module.jar");
        File pom = new File("../kjars/evaluation/pom.xml");
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.installArtifact((AFReleaseId)releaseId, kjar, pom);
    }

    @Before
    public void setup() {
        this.unit = new KModuleDeploymentUnit(GROUP_ID, ARTIFACT_ID, VERSION, null, null, "PER_PROCESS_INSTANCE");
        this.deploymentService.deploy((DeploymentUnit)this.unit);
    }

    @After
    public void cleanup() {
        this.deploymentService.undeploy((DeploymentUnit)this.unit);
    }

    @Test
    public void testProcessStartAndAbort() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("employee", "john");
        parameters.put("reason", "SpringBoot jBPM evaluation");
        long processInstanceId = this.processService.startProcess(this.unit.getIdentifier(), ARTIFACT_ID);
        Assert.assertNotNull((Object)processInstanceId);
        Assert.assertTrue((processInstanceId > 0L ? 1 : 0) != 0);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        Person person = new Person();
        person.setName("john");
        EntityManager em = this.entityManagerFactory.createEntityManager();
        em.persist((Object)person);
        Assert.assertNotNull((Object)person.getId());
        em.close();
    }
}

