/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.springboot.samples;

import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.persistenceunit.MutablePersistenceUnitInfo;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitPostProcessor;

public class ExtendedEntityManagerFactory {
    protected static final String PERSISTENCE_UNIT_NAME = "org.jbpm.domain";
    protected static final String PERSISTENCE_XML_LOCATION = "classpath:/META-INF/jbpm-persistence.xml";

    @Bean(value={"entityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean entityManagerFactory(JpaProperties jpaProperties, DataSource dataSource) {
        LocalContainerEntityManagerFactoryBean factoryBean = new LocalContainerEntityManagerFactoryBean();
        factoryBean.setPersistenceUnitName(PERSISTENCE_UNIT_NAME);
        factoryBean.setPersistenceXmlLocation(PERSISTENCE_XML_LOCATION);
        factoryBean.setJtaDataSource(dataSource);
        factoryBean.setJpaPropertyMap(jpaProperties.getProperties());
        factoryBean.setPersistenceUnitPostProcessors(new PersistenceUnitPostProcessor[]{new PersistenceUnitPostProcessor(){

            public void postProcessPersistenceUnitInfo(MutablePersistenceUnitInfo pui) {
                pui.addManagedClassName("org.jbpm.springboot.samples.entities.Person");
            }
        }});
        return factoryBean;
    }
}

