/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.gwt.functions.rebind;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.dmn.feel.runtime.FEELFunction;
import org.kie.dmn.feel.runtime.functions.BuiltInFunctions;
import org.kie.dmn.feel.runtime.functions.DateAndTimeFunction;
import org.kie.dmn.feel.runtime.functions.DateFunction;
import org.kie.dmn.feel.runtime.functions.GetValueFunction;
import org.kie.dmn.feel.runtime.functions.ModeFunction;
import org.kie.dmn.feel.runtime.functions.ParameterName;
import org.kie.dmn.feel.runtime.functions.ReplaceFunction;
import org.kie.dmn.feel.runtime.functions.TimeFunction;
import org.kie.dmn.feel.runtime.functions.extended.KieExtendedDMNFunctions;

public class MethodTemplates {
    public static String getTemplate() {
        StringBuilder builder = new StringBuilder();
        builder.append("public List<FunctionOverrideVariation> getDefinitions() {\n");
        builder.append("    ArrayList definitions = new ArrayList();\n");
        for (String signature : MethodTemplates.getFunctionSignatures()) {
            builder.append(String.format("definitions.add( %s );\n", signature));
        }
        builder.append("    return definitions;\n");
        builder.append("}");
        return builder.toString();
    }

    private static List<String> getFunctionSignatures() {
        return MethodTemplates.getFeelFunctions().stream().flatMap(function -> MethodTemplates.getFunctionSignatures(function).stream()).collect(Collectors.toList());
    }

    static List<FEELFunction> getFeelFunctions() {
        ArrayList<FEELFunction> feelFunctions = new ArrayList<FEELFunction>();
        feelFunctions.addAll(Arrays.asList(BuiltInFunctions.getFunctions()));
        feelFunctions.addAll(Arrays.asList(KieExtendedDMNFunctions.getFunctions()));
        return feelFunctions;
    }

    private static List<String> getFunctionSignatures(FEELFunction function) {
        ArrayList<String> result = new ArrayList<String>();
        for (Method declaredMethod : function.getClass().getDeclaredMethods()) {
            if (!Modifier.isPublic(declaredMethod.getModifiers()) || !declaredMethod.getName().equals("invoke")) continue;
            StringBuilder paramBuilder = new StringBuilder();
            Annotation[][] parameterAnnotations = declaredMethod.getParameterAnnotations();
            int i = 0;
            for (Annotation[] parameterAnnotation : parameterAnnotations) {
                if (i != 0) {
                    paramBuilder.append(", ");
                }
                Class<?>[] parameterTypes = declaredMethod.getParameterTypes();
                paramBuilder.append(String.format("new Parameter( \"%s\", %s )", MethodTemplates.getParameterNameAnnotation(parameterAnnotation), MethodTemplates.getType(parameterTypes[i].getTypeName())));
                ++i;
            }
            if (paramBuilder.length() == 0) {
                result.add(String.format("new FunctionOverrideVariation( %s, \"%s\" )", MethodTemplates.getReturnType(function, declaredMethod.getGenericReturnType()), function.getName()));
                continue;
            }
            result.add(String.format("new FunctionOverrideVariation( %s, \"%s\", %s )", MethodTemplates.getReturnType(function, declaredMethod.getGenericReturnType()), function.getName(), paramBuilder.toString()));
        }
        return result;
    }

    private static String getParameterNameAnnotation(Annotation[] parameterAnnotation) {
        for (Annotation annotation : parameterAnnotation) {
            if (!(annotation instanceof ParameterName)) continue;
            return ((ParameterName)annotation).value();
        }
        return "";
    }

    private static String getReturnType(FEELFunction function, Type genericReturnType) {
        Type[] actualTypeArguments;
        if (genericReturnType instanceof ParameterizedType && (actualTypeArguments = ((ParameterizedType)genericReturnType).getActualTypeArguments()).length == 1) {
            if (function instanceof DateFunction) {
                return "BuiltInType.DATE";
            }
            if (function instanceof TimeFunction) {
                return "BuiltInType.TIME";
            }
            if (function instanceof DateAndTimeFunction) {
                return "BuiltInType.DATE_TIME";
            }
            if (function instanceof GetValueFunction) {
                return "BuiltInType.UNKNOWN";
            }
            if (function instanceof ModeFunction) {
                return "BuiltInType.LIST";
            }
            if (function instanceof ReplaceFunction) {
                return "BuiltInType.STRING";
            }
            return MethodTemplates.getType(actualTypeArguments[0].getTypeName());
        }
        return "BuiltInType.UNKNOWN";
    }

    private static String getType(String typeName) {
        if (typeName.equals("java.time.temporal.TemporalAmount")) {
            return "BuiltInType.DURATION";
        }
        if (typeName.equals("java.time.temporal.TemporalAccessor")) {
            return "BuiltInType.DATE_TIME";
        }
        if (typeName.equals("java.time.temporal.Temporal")) {
            return "BuiltInType.DATE_TIME";
        }
        if (typeName.equals("java.lang.String")) {
            return "BuiltInType.STRING";
        }
        if (typeName.equals("java.lang.Boolean")) {
            return "BuiltInType.BOOLEAN";
        }
        if (typeName.startsWith("java.util.List")) {
            return "BuiltInType.LIST";
        }
        if (typeName.startsWith("java.time.Duration")) {
            return "BuiltInType.DURATION";
        }
        if (typeName.equals("java.math.BigDecimal")) {
            return "BuiltInType.NUMBER";
        }
        if (typeName.equals("java.lang.Number")) {
            return "BuiltInType.NUMBER";
        }
        if (typeName.endsWith("Range")) {
            return "BuiltInType.RANGE";
        }
        if (typeName.endsWith("ComparablePeriod")) {
            return "BuiltInType.DURATION";
        }
        if (typeName.endsWith("FEELFunction")) {
            return "BuiltInType.FUNCTION";
        }
        return "BuiltInType.UNKNOWN";
    }
}

