/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.gwt.functions.rebind;

import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.feel.gwt.functions.api.FunctionDefinition;
import org.kie.dmn.feel.gwt.functions.api.FunctionOverrideVariation;
import org.kie.dmn.feel.gwt.functions.api.Parameter;
import org.kie.dmn.feel.gwt.functions.api.Type;
import org.kie.dmn.feel.gwt.functions.client.FEELFunctionProvider;
import org.kie.dmn.feel.gwt.functions.rebind.FileCreator;
import org.kie.dmn.feel.gwt.functions.rebind.MethodTemplates;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class FileCreatorTest {
    @Mock
    private GeneratorContext context;
    @Mock
    private TreeLogger logger;
    @Mock
    private ClassSourceFileComposerFactory composerFactory;
    @Mock
    private PrintWriter printWriter;
    @Mock
    private SourceWriter sourceWriter;
    private FileCreator fileCreator;

    @Before
    public void setup() {
        this.fileCreator = (FileCreator)Mockito.spy((Object)new FileCreator(this.context, this.logger));
    }

    @Test
    public void testWrite() {
        ((FileCreator)Mockito.doReturn((Object)this.composerFactory).when((Object)this.fileCreator)).getClassSourceFileComposerFactory();
        Mockito.when((Object)this.context.tryCreate(this.logger, FileCreator.PACKAGE_NAME, FileCreator.GENERATED_CLASS_FQCN)).thenReturn((Object)this.printWriter);
        Mockito.when((Object)this.composerFactory.createSourceWriter(this.context, this.printWriter)).thenReturn((Object)this.sourceWriter);
        this.fileCreator.write();
        ((SourceWriter)Mockito.verify((Object)this.sourceWriter)).print(MethodTemplates.getTemplate());
        ((SourceWriter)Mockito.verify((Object)this.sourceWriter)).commit(this.logger);
    }

    @Test
    public void testGetClassSourceFileComposerFactory() {
        ((FileCreator)Mockito.doReturn((Object)this.composerFactory).when((Object)this.fileCreator)).makeComposerFactory();
        ClassSourceFileComposerFactory actualFactory = this.fileCreator.getClassSourceFileComposerFactory();
        ((ClassSourceFileComposerFactory)Mockito.verify((Object)this.composerFactory)).addImport(FEELFunctionProvider.class.getCanonicalName());
        ((ClassSourceFileComposerFactory)Mockito.verify((Object)this.composerFactory)).addImport(FunctionDefinition.class.getCanonicalName());
        ((ClassSourceFileComposerFactory)Mockito.verify((Object)this.composerFactory)).addImport(FunctionOverrideVariation.class.getCanonicalName());
        ((ClassSourceFileComposerFactory)Mockito.verify((Object)this.composerFactory)).addImport(BuiltInType.class.getCanonicalName());
        ((ClassSourceFileComposerFactory)Mockito.verify((Object)this.composerFactory)).addImport(Parameter.class.getCanonicalName());
        ((ClassSourceFileComposerFactory)Mockito.verify((Object)this.composerFactory)).addImport(List.class.getCanonicalName());
        ((ClassSourceFileComposerFactory)Mockito.verify((Object)this.composerFactory)).addImport(ArrayList.class.getCanonicalName());
        ((ClassSourceFileComposerFactory)Mockito.verify((Object)this.composerFactory)).addImport(Type.class.getCanonicalName());
        ((ClassSourceFileComposerFactory)Mockito.verify((Object)this.composerFactory)).addImplementedInterface(FEELFunctionProvider.class.getName());
        Assertions.assertThat((Object)actualFactory).isSameAs((Object)this.composerFactory);
    }

    @Test
    public void testMakeComposerFactory() {
        ClassSourceFileComposerFactory factory = this.fileCreator.makeComposerFactory();
        Assertions.assertThat((String)factory.getCreatedPackage()).isEqualTo(FileCreator.PACKAGE_NAME);
        Assertions.assertThat((String)factory.getCreatedClassShortName()).isEqualTo(FileCreator.GENERATED_CLASS_FQCN);
    }
}

