/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.client.showcase;

import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.File;
import java.time.Duration;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.support.ui.WebDriverWait;

public class FEELShowcaseIT {
    private static final String INDEX_HTML = "target/kie-dmn-feel-gwt-showcase/index.html";
    private static final String INDEX_HTML_PATH = "file:///" + new File("target/kie-dmn-feel-gwt-showcase/index.html").getAbsolutePath();
    private static final boolean HEADLESS = true;
    private WebDriver driver;

    @BeforeClass
    public static void setupClass() {
        WebDriverManager.firefoxdriver().setup();
    }

    @Before
    public void openDMNDesigner() {
        this.driver = new FirefoxDriver(this.getFirefoxOptions());
        this.driver.get(INDEX_HTML_PATH);
    }

    @After
    public void quitDriver() {
        this.driver.quit();
    }

    @Test
    public void testEvaluation() {
        this.waitOperation().withMessage("Wait until FEEL demo appears").until(e -> e.findElement(By.cssSelector((String)"#root")));
        this.assertEvaluation("2 + 4", "6");
        this.assertEvaluation("\"Hello\" + \" world!\"", "Hello world!");
        this.assertEvaluation("[1, 2, 3]", "[1, 2, 3]");
        this.assertEvaluation("[\"Sao Paulo\", \"Valladolid\", \"Campinas\"][3]", "Campinas");
        this.assertEvaluation("date(1992, 02, 01).year", "1992");
        this.assertEvaluation("some i in [1, 2, 3, 4, 5] satisfies i > 4", "true");
        this.assertEvaluation("some i in [1, 2, 3, 4, 5] satisfies i > 5", "false");
        this.assertEvaluation("1 in [1..10]", "true");
        this.assertEvaluation("1 in (1..10]", "false");
        this.assertEvaluation("string length(\"DMN\")", "3");
        this.assertEvaluation("substring(\"Learn DMN in 15 minutes\", 6, 3)", "DMN");
        this.assertEvaluation("lower case(\"LEARN-DMN-IN-15-MINUTES.COM\")", "learn-dmn-in-15-minutes.com");
        this.assertEvaluation("upper case(\"learn-dmn-in-15-minutes.com\")", "LEARN-DMN-IN-15-MINUTES.COM");
        this.assertEvaluation("sum([1, 2, 3, 4, 5])", "15");
        this.assertEvaluation("if 20 > 0 then \"YES\" else \"NO\"", "YES");
        this.assertEvaluation("if (20 - (10 * 2)) > 0 then \"YES\" else \"NO\"", "NO");
    }

    private void assertEvaluation(String feelExpression, String expectedEvaluation) {
        WebElement feelExpressionTextBox = this.driver.findElement(By.cssSelector((String)"[data-field='text']"));
        WebElement feelEvaluation = this.driver.findElement(By.cssSelector((String)"[data-field='evaluation']"));
        feelExpressionTextBox.clear();
        feelExpressionTextBox.sendKeys(new CharSequence[]{feelExpression});
        Assertions.assertThat((String)feelEvaluation.getAttribute("value")).isEqualTo(expectedEvaluation);
    }

    private FirefoxOptions getFirefoxOptions() {
        FirefoxOptions firefoxOptions = new FirefoxOptions();
        firefoxOptions.setHeadless(true);
        firefoxOptions.setProfile(this.getFirefoxProfile());
        return firefoxOptions;
    }

    private FirefoxProfile getFirefoxProfile() {
        FirefoxProfile profile = new FirefoxProfile();
        profile.setPreference("webdriver.log.init", true);
        profile.setPreference("webdriver.log.browser.ignore", true);
        profile.setPreference("webdriver.log.driver.ignore", true);
        profile.setPreference("webdriver.log.profiler.ignore", true);
        return profile;
    }

    private WebDriverWait waitOperation() {
        return new WebDriverWait(this.driver, Duration.ofSeconds(10L).getSeconds());
    }
}

