/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions.twovaluelogic;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.twovaluelogic.NNSumFunction;

public class SumFunctionTest {
    private NNSumFunction sumFunction;

    @Before
    public void setUp() {
        this.sumFunction = new NNSumFunction();
    }

    @Test
    public void invokeNumberParamNull() {
        FunctionTestUtil.assertResult(this.sumFunction.invoke((Number)null), null);
    }

    @Test
    public void invokeNumberParamUnsupportedNumber() {
        FunctionTestUtil.assertResultError(this.sumFunction.invoke((Number)Double.NaN), InvalidParametersEvent.class);
    }

    @Test
    public void invokeNumberParamSupportedNumber() {
        FunctionTestUtil.assertResult(this.sumFunction.invoke((Number)BigDecimal.TEN), BigDecimal.TEN);
        FunctionTestUtil.assertResult(this.sumFunction.invoke((Number)10), BigDecimal.TEN);
        FunctionTestUtil.assertResult(this.sumFunction.invoke((Number)-10), BigDecimal.valueOf(-10L));
        FunctionTestUtil.assertResult(this.sumFunction.invoke((Number)10.12), BigDecimal.valueOf(10.12));
    }

    @Test
    public void invokeListParam() {
        FunctionTestUtil.assertResult(this.sumFunction.invoke((List)null), null);
    }

    @Test
    public void invokeListParamContainsUnsupportedNumber() {
        FunctionTestUtil.assertResultError(this.sumFunction.invoke(Arrays.asList(10, 2, Double.NaN)), InvalidParametersEvent.class);
    }

    @Test
    public void invokeListParamContainsUnsupportedType() {
        FunctionTestUtil.assertResultError(this.sumFunction.invoke(Arrays.asList(10, "test", 2)), InvalidParametersEvent.class);
    }

    @Test
    public void invokeListParamSupportedTypes() {
        FunctionTestUtil.assertResult(this.sumFunction.invoke(Arrays.asList(4, -1, 12.1, 5L, BigDecimal.TEN)), BigDecimal.valueOf(30.1));
    }

    @Test
    public void invokeListParamSupportedTypesWithNull() {
        FunctionTestUtil.assertResult(this.sumFunction.invoke(Arrays.asList(4, -1, 12.1, null, 5L, null, BigDecimal.TEN)), BigDecimal.valueOf(30.1));
    }

    @Test
    public void invokeArrayParam() {
        FunctionTestUtil.assertResult(this.sumFunction.invoke((Object[])null), null);
    }

    @Test
    public void invokeArrayParamContainsUnsupportedNumber() {
        FunctionTestUtil.assertResultError(this.sumFunction.invoke(new Object[]{10, 2, Double.NaN}), InvalidParametersEvent.class);
    }

    @Test
    public void invokeArrayParamContainsUnsupportedType() {
        FunctionTestUtil.assertResultError(this.sumFunction.invoke(new Object[]{10, "test", 2}), InvalidParametersEvent.class);
    }

    @Test
    public void invokeArrayParamSupportedTypes() {
        FunctionTestUtil.assertResult(this.sumFunction.invoke(new Object[]{4, -1, 12.1, 5L, BigDecimal.TEN}), BigDecimal.valueOf(30.1));
    }

    @Test
    public void invokeArrayParamSupportedTypesWithNull() {
        FunctionTestUtil.assertResult(this.sumFunction.invoke(new Object[]{4, -1, null, 12.1, 5L, null, BigDecimal.TEN, null}), BigDecimal.valueOf(30.1));
    }
}

