/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.ast;

import java.math.BigDecimal;
import java.math.MathContext;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.function.BinaryOperator;
import org.antlr.v4.runtime.ParserRuleContext;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.util.EvalHelper;

public class InfixOpNode
extends BaseNode {
    private InfixOperator operator;
    private BaseNode left;
    private BaseNode right;

    public InfixOpNode(ParserRuleContext ctx, BaseNode left, String op, BaseNode right) {
        super(ctx);
        this.left = left;
        this.operator = InfixOperator.determineOperator(op);
        this.right = right;
    }

    public InfixOperator getOperator() {
        return this.operator;
    }

    public void setOperator(InfixOperator operator) {
        this.operator = operator;
    }

    public boolean isBoolean() {
        return this.operator.isBoolean();
    }

    public BaseNode getLeft() {
        return this.left;
    }

    public void setLeft(BaseNode left) {
        this.left = left;
    }

    public BaseNode getRight() {
        return this.right;
    }

    public void setRight(BaseNode right) {
        this.right = right;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Type getResultType() {
        if (this.operator.isBoolean()) {
            return BuiltInType.BOOLEAN;
        }
        switch (1.$SwitchMap$org$kie$dmn$feel$lang$ast$InfixOpNode$InfixOperator[this.operator.ordinal()]) {
            case 1: 
            case 2: {
                if (this.left.getResultType() == BuiltInType.NUMBER && this.right.getResultType() == BuiltInType.NUMBER) {
                    return BuiltInType.NUMBER;
                }
                if (this.left.getResultType() == BuiltInType.DATE_TIME && this.right.getResultType() == BuiltInType.DATE_TIME) {
                    return BuiltInType.DATE_TIME;
                }
                if (this.left.getResultType() == BuiltInType.TIME && this.right.getResultType() == BuiltInType.TIME) {
                    return BuiltInType.TIME;
                }
                if (this.left.getResultType() != BuiltInType.DURATION && this.right.getResultType() != BuiltInType.DURATION) ** GOTO lbl19
                if (this.left.getResultType() == BuiltInType.DATE_TIME || this.right.getResultType() == BuiltInType.DATE_TIME) {
                    return BuiltInType.DATE_TIME;
                }
                if (this.left.getResultType() == BuiltInType.TIME || this.right.getResultType() == BuiltInType.TIME) {
                    return BuiltInType.TIME;
                }
                if (this.left.getResultType() == BuiltInType.DURATION && this.right.getResultType() == BuiltInType.DURATION) {
                    return BuiltInType.DURATION;
                }
                ** GOTO lbl21
lbl19:
                // 1 sources

                if (this.left.getResultType() == BuiltInType.STRING && this.right.getResultType() == BuiltInType.STRING) {
                    return BuiltInType.STRING;
                }
            }
lbl21:
            // 4 sources

            case 3: 
            case 4: {
                if (this.left.getResultType() == BuiltInType.NUMBER && this.right.getResultType() == BuiltInType.NUMBER) {
                    return BuiltInType.NUMBER;
                }
                if (!(this.left.getResultType() != BuiltInType.DURATION && this.right.getResultType() != BuiltInType.DURATION || this.left.getResultType() != BuiltInType.NUMBER && this.right.getResultType() != BuiltInType.NUMBER)) {
                    return BuiltInType.NUMBER;
                }
            }
            case 5: {
                if (this.left.getResultType() != BuiltInType.NUMBER || this.right.getResultType() != BuiltInType.NUMBER) break;
                return BuiltInType.NUMBER;
            }
        }
        return BuiltInType.UNKNOWN;
    }

    @Override
    public Object evaluate(EvaluationContext ctx) {
        Object left = this.left.evaluate(ctx);
        Object right = this.right.evaluate(ctx);
        switch (this.operator) {
            case ADD: {
                return this.add(left, right, ctx);
            }
            case SUB: {
                return this.sub(left, right, ctx);
            }
            case MULT: {
                return this.mult(left, right, ctx);
            }
            case DIV: {
                return this.div(left, right, ctx);
            }
            case POW: {
                return this.math(left, right, ctx, (l, r) -> l.pow(r.intValue(), MathContext.DECIMAL128));
            }
            case AND: {
                return this.and(left, right, ctx);
            }
            case OR: {
                return this.or(left, right, ctx);
            }
            case LTE: {
                return EvalHelper.compare(left, right, ctx, (l, r) -> l.compareTo(r) <= 0);
            }
            case LT: {
                return EvalHelper.compare(left, right, ctx, (l, r) -> l.compareTo(r) < 0);
            }
            case GT: {
                return EvalHelper.compare(left, right, ctx, (l, r) -> l.compareTo(r) > 0);
            }
            case GTE: {
                return EvalHelper.compare(left, right, ctx, (l, r) -> l.compareTo(r) >= 0);
            }
            case EQ: {
                return EvalHelper.isEqual(left, right, ctx);
            }
            case NE: {
                Boolean result = EvalHelper.isEqual(left, right, ctx);
                return result != null ? Boolean.valueOf(result == false) : null;
            }
        }
        return null;
    }

    private Object add(Object left, Object right, EvaluationContext ctx) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof String && right instanceof String) {
            return (String)left + (String)right;
        }
        if (left instanceof Period && right instanceof Period) {
            return ((Period)left).plus((Period)right);
        }
        if (left instanceof Duration && right instanceof Duration) {
            return ((Duration)left).plus((Duration)right);
        }
        if (left instanceof ZonedDateTime && right instanceof Period) {
            return ((ZonedDateTime)left).plus((Period)right);
        }
        if (left instanceof OffsetDateTime && right instanceof Period) {
            return ((OffsetDateTime)left).plus((Period)right);
        }
        if (left instanceof LocalDateTime && right instanceof Period) {
            return ((LocalDateTime)left).plus((Period)right);
        }
        if (left instanceof LocalDate && right instanceof Period) {
            return ((LocalDate)left).plus((Period)right);
        }
        if (left instanceof ZonedDateTime && right instanceof Duration) {
            return ((ZonedDateTime)left).plus((Duration)right);
        }
        if (left instanceof OffsetDateTime && right instanceof Duration) {
            return ((OffsetDateTime)left).plus((Duration)right);
        }
        if (left instanceof LocalDateTime && right instanceof Duration) {
            return ((LocalDateTime)left).plus((Duration)right);
        }
        if (left instanceof LocalDate && right instanceof Duration) {
            return ((LocalDate)left).plusDays(((Duration)right).toDays());
        }
        if (left instanceof Period && right instanceof ZonedDateTime) {
            return ((ZonedDateTime)right).plus((Period)left);
        }
        if (left instanceof Period && right instanceof OffsetDateTime) {
            return ((OffsetDateTime)right).plus((Period)left);
        }
        if (left instanceof Period && right instanceof LocalDateTime) {
            return ((LocalDateTime)right).plus((Period)left);
        }
        if (left instanceof Period && right instanceof LocalDate) {
            return ((LocalDate)right).plus((Period)left);
        }
        if (left instanceof Duration && right instanceof ZonedDateTime) {
            return ((ZonedDateTime)right).plus((Duration)left);
        }
        if (left instanceof Duration && right instanceof OffsetDateTime) {
            return ((OffsetDateTime)right).plus((Duration)left);
        }
        if (left instanceof Duration && right instanceof LocalDateTime) {
            return ((LocalDateTime)right).plus((Duration)left);
        }
        if (left instanceof Duration && right instanceof LocalDate) {
            return ((LocalDate)right).plusDays(((Duration)left).toDays());
        }
        if (left instanceof LocalTime && right instanceof Duration) {
            return ((LocalTime)left).plus((Duration)right);
        }
        if (left instanceof Duration && right instanceof LocalTime) {
            return ((LocalTime)right).plus((Duration)left);
        }
        if (left instanceof OffsetTime && right instanceof Duration) {
            return ((OffsetTime)left).plus((Duration)right);
        }
        if (left instanceof Duration && right instanceof OffsetTime) {
            return ((OffsetTime)right).plus((Duration)left);
        }
        return this.math(left, right, ctx, (l, r) -> l.add((BigDecimal)r, MathContext.DECIMAL128));
    }

    private Object sub(Object left, Object right, EvaluationContext ctx) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Temporal && right instanceof Temporal) {
            if (left instanceof ZonedDateTime || left instanceof OffsetDateTime) {
                if (right instanceof LocalDateTime) {
                    right = ZonedDateTime.of((LocalDateTime)right, ZoneId.systemDefault());
                }
            } else if (right instanceof ZonedDateTime || right instanceof OffsetDateTime) {
                if (left instanceof LocalDateTime) {
                    left = ZonedDateTime.of((LocalDateTime)left, ZoneId.systemDefault());
                }
            } else if (right instanceof LocalDate && left instanceof LocalDate) {
                return Duration.ofDays(ChronoUnit.DAYS.between((LocalDate)right, (LocalDate)left));
            }
            return Duration.between((Temporal)right, (Temporal)left);
        }
        if (left instanceof Period && right instanceof Period) {
            return ((Period)left).minus((Period)right);
        }
        if (left instanceof Duration && right instanceof Duration) {
            return ((Duration)left).minus((Duration)right);
        }
        if (left instanceof ZonedDateTime && right instanceof Period) {
            return ((ZonedDateTime)left).minus((Period)right);
        }
        if (left instanceof OffsetDateTime && right instanceof Period) {
            return ((OffsetDateTime)left).minus((Period)right);
        }
        if (left instanceof LocalDateTime && right instanceof Period) {
            return ((LocalDateTime)left).minus((Period)right);
        }
        if (left instanceof LocalDate && right instanceof Period) {
            return ((LocalDate)left).minus((Period)right);
        }
        if (left instanceof ZonedDateTime && right instanceof Duration) {
            return ((ZonedDateTime)left).minus((Duration)right);
        }
        if (left instanceof OffsetDateTime && right instanceof Duration) {
            return ((OffsetDateTime)left).minus((Duration)right);
        }
        if (left instanceof LocalDateTime && right instanceof Duration) {
            return ((LocalDateTime)left).minus((Duration)right);
        }
        if (left instanceof LocalDate && right instanceof Duration) {
            return ((LocalDate)left).minusDays(((Duration)right).toDays());
        }
        if (left instanceof LocalTime && right instanceof Duration) {
            return ((LocalTime)left).minus((Duration)right);
        }
        if (left instanceof OffsetTime && right instanceof Duration) {
            return ((OffsetTime)left).minus((Duration)right);
        }
        return this.math(left, right, ctx, (l, r) -> l.subtract((BigDecimal)r, MathContext.DECIMAL128));
    }

    private Object mult(Object left, Object right, EvaluationContext ctx) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Duration && right instanceof Number) {
            return ((Duration)left).multipliedBy(((Number)right).longValue());
        }
        if (left instanceof Number && right instanceof Duration) {
            return Duration.ofSeconds(EvalHelper.getBigDecimalOrNull(left).multiply(EvalHelper.getBigDecimalOrNull(((Duration)right).getSeconds()), MathContext.DECIMAL128).longValue());
        }
        if (left instanceof Duration && right instanceof Duration) {
            return EvalHelper.getBigDecimalOrNull(((Duration)left).getSeconds()).multiply(EvalHelper.getBigDecimalOrNull(((Duration)right).getSeconds()), MathContext.DECIMAL128);
        }
        if (left instanceof Period && right instanceof Number) {
            return Period.ofMonths(EvalHelper.getBigDecimalOrNull(((Period)left).toTotalMonths()).multiply(EvalHelper.getBigDecimalOrNull(((Number)right).longValue()), MathContext.DECIMAL128).intValue());
        }
        if (left instanceof Number && right instanceof Period) {
            return Period.ofMonths(EvalHelper.getBigDecimalOrNull(left).multiply(EvalHelper.getBigDecimalOrNull(((Period)right).toTotalMonths()), MathContext.DECIMAL128).intValue());
        }
        if (left instanceof Period && right instanceof Period) {
            return EvalHelper.getBigDecimalOrNull(((Period)left).toTotalMonths()).multiply(EvalHelper.getBigDecimalOrNull(((Period)right).toTotalMonths()), MathContext.DECIMAL128);
        }
        return this.math(left, right, ctx, (l, r) -> l.multiply((BigDecimal)r, MathContext.DECIMAL128));
    }

    private Object div(Object left, Object right, EvaluationContext ctx) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Duration && right instanceof Number) {
            return ((Duration)left).dividedBy(((Number)right).longValue());
        }
        if (left instanceof Number && right instanceof Duration) {
            return Duration.ofSeconds(EvalHelper.getBigDecimalOrNull(left).divide(EvalHelper.getBigDecimalOrNull(((Duration)right).getSeconds()), MathContext.DECIMAL128).longValue());
        }
        if (left instanceof Duration && right instanceof Duration) {
            return EvalHelper.getBigDecimalOrNull(((Duration)left).getSeconds()).divide(EvalHelper.getBigDecimalOrNull(((Duration)right).getSeconds()), MathContext.DECIMAL128);
        }
        if (left instanceof Period && right instanceof Number) {
            return Period.ofMonths(EvalHelper.getBigDecimalOrNull(((Period)left).toTotalMonths()).divide(EvalHelper.getBigDecimalOrNull(((Number)right).longValue()), MathContext.DECIMAL128).intValue());
        }
        if (left instanceof Number && right instanceof Period) {
            return Period.ofMonths(EvalHelper.getBigDecimalOrNull(left).divide(EvalHelper.getBigDecimalOrNull(((Period)right).toTotalMonths()), MathContext.DECIMAL128).intValue());
        }
        if (left instanceof Period && right instanceof Period) {
            return EvalHelper.getBigDecimalOrNull(((Period)left).toTotalMonths()).divide(EvalHelper.getBigDecimalOrNull(((Period)right).toTotalMonths()), MathContext.DECIMAL128);
        }
        return this.math(left, right, ctx, (l, r) -> l.divide((BigDecimal)r, MathContext.DECIMAL128));
    }

    private Object math(Object left, Object right, EvaluationContext ctx, BinaryOperator<BigDecimal> op) {
        BigDecimal l = EvalHelper.getBigDecimalOrNull(left);
        BigDecimal r = EvalHelper.getBigDecimalOrNull(right);
        if (l == null || r == null) {
            return null;
        }
        try {
            return op.apply(l, r);
        }
        catch (ArithmeticException e) {
            return null;
        }
    }

    private Object and(Object left, Object right, EvaluationContext ctx) {
        Boolean l = EvalHelper.getBooleanOrNull(left);
        Boolean r = EvalHelper.getBooleanOrNull(right);
        if (l == null && r == null || l == null && r == true || r == null && l.booleanValue()) {
            return null;
        }
        if (l == null || r == null) {
            return false;
        }
        return l != false && r != false;
    }

    private Object or(Object left, Object right, EvaluationContext ctx) {
        Boolean l = EvalHelper.getBooleanOrNull(left);
        Boolean r = EvalHelper.getBooleanOrNull(right);
        if (l == null && r == null || l == null && r == false || r == null && !l.booleanValue()) {
            return null;
        }
        if (l == null || r == null) {
            return true;
        }
        return l != false || r != false;
    }

    public static enum InfixOperator {
        ADD("+"),
        SUB("-"),
        MULT("*"),
        DIV("/"),
        POW("**"),
        LTE("<="),
        LT("<"),
        GT(">"),
        GTE(">="),
        EQ("="),
        NE("!="),
        AND("and"),
        OR("or");

        public final String symbol;

        private InfixOperator(String symbol) {
            this.symbol = symbol;
        }

        public static InfixOperator determineOperator(String symbol) {
            for (InfixOperator op : InfixOperator.values()) {
                if (!op.symbol.equals(symbol)) continue;
                return op;
            }
            throw new IllegalArgumentException("No operator found for symbol '" + symbol + "'");
        }

        public boolean isBoolean() {
            return this == LTE || this == LT || this == GT || this == GTE || this == EQ || this == NE || this == AND || this == OR;
        }
    }
}

