/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.JsonSchema;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.openapi.BaseDMNOASTest;
import org.kie.dmn.openapi.DMNOASGeneratorFactory;
import org.kie.dmn.openapi.model.DMNOASResult;

public class DSMultipleOutputTest
extends BaseDMNOASTest {
    @Test
    public void test() throws Exception {
        DMNRuntime runtime = this.createRuntime("DSMultipleOutput.dmn", this.getClass());
        DMNOASResult result = DMNOASGeneratorFactory.generator((Collection)runtime.getModels()).build();
        DMNModel modelUnderTest = runtime.getModel("https://kiegroup.org/dmn/_A289CCD2-6759-47F6-87CD-F8E12880053F", "DSMultipleOutput");
        ObjectNode syntheticJSONSchema = this.synthesizeSchemaForDS(result, modelUnderTest, "DecisionService-1");
        JsonSchema validator = this.getJSONSchema((JsonNode)syntheticJSONSchema);
        Assertions.assertThat(this.validateUsing(validator, "{ \"an order\":123 }")).isNotEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"a name\":123 }")).isNotEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"a name\":\"John Doe\" }")).isEmpty();
    }
}

