/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.ruleset2dmn;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.rule_set.SimpleRule;

public class SimpleRuleRow {
    final SimpleRule r;
    final Map<String, List<SimplePredicate>> map = new LinkedHashMap<String, List<SimplePredicate>>();

    public SimpleRuleRow(SimpleRule r) {
        this.r = r;
        Predicate rootPredicate = r.getPredicate();
        if (rootPredicate instanceof SimplePredicate) {
            SimplePredicate sp = (SimplePredicate)rootPredicate;
            this.map.computeIfAbsent(sp.getField(), k -> new ArrayList()).add(sp);
        } else {
            if (!(rootPredicate instanceof CompoundPredicate)) {
                throw new UnsupportedOperationException("Was expecting a CompoundPredicate, found: " + rootPredicate.getClass());
            }
            CompoundPredicate cPredicate = (CompoundPredicate)rootPredicate;
            if (cPredicate.getBooleanOperator() != CompoundPredicate.BooleanOperator.AND) {
                throw new UnsupportedOperationException("Only AND operator usage is supported in CompoundPredicate to convert to a Decision Table.");
            }
            for (Predicate c : cPredicate.getPredicates()) {
                SimplePredicate sp = (SimplePredicate)c;
                this.map.computeIfAbsent(sp.getField(), k -> new ArrayList()).add(sp);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.r.getId()).append(" -> ").append(this.r.getScore()).append("\n");
        for (Map.Entry<String, List<SimplePredicate>> kv : this.map.entrySet()) {
            sb.append(kv.getKey()).append(" ");
            for (SimplePredicate v : kv.getValue()) {
                sb.append(v.getOperator()).append(v.getValue()).append(" ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

