/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.signavio.feel.runtime.functions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class ZipFunction
extends BaseFEELFunction {
    public ZipFunction() {
        super("zip");
    }

    public FEELFnResult<List> invoke(@ParameterName(value="attributes") List<?> attributes, @ParameterName(value="values") Object[] values) {
        if (attributes.isEmpty()) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "attributes", "attributes cannot be empty"));
        }
        if (!(attributes.get(0) instanceof String)) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "attributes", "attributes must be a list of string"));
        }
        if (values.length != attributes.size()) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "values", "values must be a list of the same size as of attributes"));
        }
        ArrayList result = new ArrayList();
        for (int aIdx = 0; aIdx < values.length; ++aIdx) {
            if (!(values[aIdx] instanceof List)) {
                return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "values", "each value must be a list"));
            }
            List value = (List)values[aIdx];
            if (result.isEmpty()) {
                value.forEach(x -> result.add(new HashMap()));
            } else if (value.size() != result.size()) {
                return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "values", "each value must be consistent in size"));
            }
            Object attribute = attributes.get(aIdx);
            for (int vIdx = 0; vIdx < value.size(); ++vIdx) {
                ((Map)result.get(vIdx)).put(attribute, value.get(vIdx));
            }
        }
        return FEELFnResult.ofResult(result);
    }
}

