/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.util.List;
import javax.xml.stream.Location;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.marshalling.v1_1.DMNMarshaller;
import org.kie.dmn.backend.marshalling.v1_1.DMNMarshallerFactory;
import org.kie.dmn.core.DMNInputRuntimeTest;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.feel.parser.feel11.FEELParser;
import org.kie.dmn.model.v1_1.DMNModelInstrumentedBase;
import org.kie.dmn.model.v1_1.Definitions;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.DMNValidatorFactory;
import org.kie.dmn.validation.Msg;
import org.kie.dmn.validation.ValidationMsg;

public class ValidatorTest {
    private static DMNValidator validator;

    @BeforeClass
    public static void init() {
        validator = DMNValidatorFactory.newValidator();
    }

    @AfterClass
    public static void dispose() {
        validator.dispose();
    }

    @Test
    public void testDryRun() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0001-input-data-string.dmn", DMNInputRuntimeTest.class);
        DMNModel dmnModel = runtime.getModel("https://github.com/droolsjbpm/kie-dmn", "0001-input-data-string");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Definitions definitions = dmnModel.getDefinitions();
        Assert.assertThat((Object)definitions, (Matcher)CoreMatchers.notNullValue());
        DMNValidatorFactory.newValidator().validateModel(definitions);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Definitions utilDefinitions(String filename, String modelName) {
        try {
            List validateXML = validator.validateSchema(new File(this.getClass().getResource(filename).toURI()));
            Assert.assertThat((String)"using unit test method utilDefinitions must received a XML valid DMN file", (Object)validateXML, (Matcher)IsEmptyCollection.empty());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            Assert.fail((String)"Unable for the test suite to locate the file for XML validation.");
        }
        DMNMarshaller marshaller = DMNMarshallerFactory.newDefaultMarshaller();
        try (InputStreamReader isr = new InputStreamReader(this.getClass().getResourceAsStream(filename));){
            Definitions definitions2 = marshaller.unmarshal((Reader)isr);
            Assert.assertThat((Object)definitions2, (Matcher)CoreMatchers.notNullValue());
            Definitions definitions = definitions2;
            return definitions;
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)"Unable for the test suite to locate the file for validation.");
            return null;
        }
    }

    @Test
    public void testInvalidXml() throws URISyntaxException {
        List validateXML = validator.validateSchema(new File(this.getClass().getResource("invalidXml.dmn").toURI()));
        Assert.assertTrue((!validateXML.isEmpty() ? 1 : 0) != 0);
        validateXML.forEach(System.err::println);
    }

    @Test
    public void testTYPEREF_NO_NS() throws URISyntaxException {
        List validateXML = validator.validateSchema(new File(this.getClass().getResource("TYPEREF_NO_NS.dmn").toURI()));
        Assert.assertTrue((!validateXML.isEmpty() ? 1 : 0) != 0);
        validateXML.forEach(System.err::println);
    }

    @Test
    public void testBKM_MISSING_EXPR() {
        Definitions definitions = this.utilDefinitions("BKM_MISSING_EXPR.dmn", "BKM_MISSING_EXPR");
        List validate = validator.validateModel(definitions);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessage().equals((Object)Msg.BKM_MISSING_EXPR)));
    }

    @Test
    public void testBKM_MISSING_VAR() {
        Definitions definitions = this.utilDefinitions("BKM_MISSING_VAR.dmn", "BKM_MISSING_VAR");
        List validate = validator.validateModel(definitions);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessage().equals((Object)Msg.BKM_MISSING_VAR)));
    }

    @Test
    public void testCONTEXT_DUP_ENTRY() {
        Definitions definitions = this.utilDefinitions("CONTEXT_DUP_ENTRY.dmn", "CONTEXT_DUP_ENTRY");
        List validate = validator.validateModel(definitions);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessage().equals((Object)Msg.CONTEXT_DUP_ENTRY)));
    }

    @Test
    public void testCONTEXT_ENTRY_NOTYPEREF() {
        Definitions definitions = this.utilDefinitions("CONTEXT_ENTRY_NOTYPEREF.dmn", "CONTEXT_ENTRY_NOTYPEREF");
        List validate = validator.validateModel(definitions);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessage().equals((Object)Msg.CONTEXT_ENTRY_NOTYPEREF)));
    }

    @Test
    public void testDECISION_MISSING_EXPR() {
        Definitions definitions = this.utilDefinitions("DECISION_MISSING_EXPR.dmn", "DECISION_MISSING_EXPR");
        List validate = validator.validateModel(definitions);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessage().equals((Object)Msg.DECISION_MISSING_EXPR)));
    }

    @Test
    public void testDECISION_MISSING_VAR() {
        Definitions definitions = this.utilDefinitions("DECISION_MISSING_VAR.dmn", "DECISION_MISSING_VAR");
        List validate = validator.validateModel(definitions);
        Assert.assertEquals((long)1L, (long)validate.stream().filter(p -> p.getMessage().equals((Object)Msg.DECISION_MISSING_VAR)).count());
        ValidationMsg msg0 = validate.stream().filter(p -> p.getMessage().equals((Object)Msg.DECISION_MISSING_VAR)).findFirst().get();
        Assert.assertEquals((Object)Msg.DECISION_MISSING_VAR, (Object)msg0.getMessage());
        DMNModelInstrumentedBase base = (DMNModelInstrumentedBase)msg0.getReference();
        Location loc0 = base.getLocation();
        Assert.assertEquals((String)"In the DECISION_MISSING_VAR.dmn file, the element Decision faulty here is on line 24. ", (long)24L, (long)loc0.getLineNumber());
    }

    @Test
    public void testDECISION_MISSING_VARbis() {
        Definitions definitions = this.utilDefinitions("DECISION_MISSING_VARbis.dmn", "DECISION_MISSING_VARbis");
        List validate = validator.validateModel(definitions);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessage().equals((Object)Msg.DECISION_MISSING_VAR)));
    }

    @Test
    public void testDRGELEM_NOT_UNIQUE() {
        Definitions definitions = this.utilDefinitions("DRGELEM_NOT_UNIQUE.dmn", "DRGELEM_NOT_UNIQUE");
        List validate = validator.validateModel(definitions);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessage().equals((Object)Msg.DRGELEM_NOT_UNIQUE)));
    }

    @Test
    public void testDTABLE_MULTIPLEOUT_NAME() {
        Definitions definitions = this.utilDefinitions("DTABLE_MULTIPLEOUTPUT_WRONG_OUTPUT.dmn", "DTABLE_MULTIPLEOUTPUT_WRONG_OUTPUT");
        List validate = validator.validateModel(definitions);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessage().equals((Object)Msg.DTABLE_MULTIPLEOUT_NAME)));
    }

    @Test
    public void testDTABLE_MULTIPLEOUT_TYPEREF() {
        Definitions definitions = this.utilDefinitions("DTABLE_MULTIPLEOUTPUT_WRONG_OUTPUT.dmn", "DTABLE_MULTIPLEOUTPUT_WRONG_OUTPUT");
        List validate = validator.validateModel(definitions);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessage().equals((Object)Msg.DTABLE_MULTIPLEOUT_TYPEREF)));
    }

    @Test
    public void testDTABLE_PRIORITY_MISSING_OUTVALS() {
        Definitions definitions = this.utilDefinitions("DTABLE_PRIORITY_MISSING_OUTVALS.dmn", "DTABLE_PRIORITY_MISSING_OUTVALS");
        List validate = validator.validateModel(definitions);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessage().equals((Object)Msg.DTABLE_PRIORITY_MISSING_OUTVALS)));
    }

    @Test
    public void testDTABLE_SINGLEOUT_NONAME() {
        Definitions definitions = this.utilDefinitions("DTABLE_SINGLEOUTPUT_WRONG_OUTPUT.dmn", "DTABLE_SINGLEOUTPUT_WRONG_OUTPUT");
        List validate = validator.validateModel(definitions);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessage().equals((Object)Msg.DTABLE_SINGLEOUT_NONAME)));
    }

    @Test
    public void testDTABLE_SINGLEOUT_NOTYPEREF() {
        Definitions definitions = this.utilDefinitions("DTABLE_SINGLEOUTPUT_WRONG_OUTPUT.dmn", "DTABLE_SINGLEOUTPUT_WRONG_OUTPUT");
        List validate = validator.validateModel(definitions);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessage().equals((Object)Msg.DTABLE_SINGLEOUT_NOTYPEREF)));
    }

    @Test
    public void testELEMREF_MISSING_TARGET() {
        Definitions definitions = this.utilDefinitions("ELEMREF_MISSING_TARGET.dmn", "ELEMREF_MISSING_TARGET");
        List validate = validator.validateModel(definitions);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessage().equals((Object)Msg.ELEMREF_MISSING_TARGET)));
    }

    @Test
    public void testELEMREF_NOHASH() {
        Definitions definitions = this.utilDefinitions("ELEMREF_NOHASH.dmn", "ELEMREF_NOHASH");
        List validate = validator.validateModel(definitions);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessage().equals((Object)Msg.ELEMREF_NOHASH)));
    }

    @Test
    public void testFORMAL_PARAM_DUPLICATED() {
        Definitions definitions = this.utilDefinitions("FORMAL_PARAM_DUPLICATED.dmn", "FORMAL_PARAM_DUPLICATED");
        List validate = validator.validateModel(definitions);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessage().equals((Object)Msg.FORMAL_PARAM_DUPLICATED)));
    }

    @Test
    public void testINPUTDATA_MISSING_VAR() {
        Definitions definitions = this.utilDefinitions("INPUTDATA_MISSING_VAR.dmn", "INPUTDATA_MISSING_VAR");
        List validate = validator.validateModel(definitions);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessage().equals((Object)Msg.INPUTDATA_MISSING_VAR)));
    }

    @Test
    public void testINVOCATION_INCONSISTENT_PARAM_NAMES() {
        Definitions definitions = this.utilDefinitions("INVOCATION_INCONSISTENT_PARAM_NAMES.dmn", "INVOCATION_INCONSISTENT_PARAM_NAMES");
        List validate = validator.validateModel(definitions);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessage().equals((Object)Msg.INVOCATION_INCONSISTENT_PARAM_NAMES)));
    }

    @Test
    public void testINVOCATION_MISSING_TARGET() {
        Definitions definitions = this.utilDefinitions("INVOCATION_MISSING_TARGET.dmn", "INVOCATION_MISSING_TARGET");
        List validate = validator.validateModel(definitions);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessage().equals((Object)Msg.INVOCATION_MISSING_TARGET)));
    }

    @Ignore(value="known current limitation")
    @Test
    public void testINVOCATION_MISSING_TARGETRbis() {
        Definitions definitions = this.utilDefinitions("INVOCATION_MISSING_TARGETbis.dmn", "INVOCATION_MISSING_TARGETbis");
        List validate = validator.validateModel(definitions);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessage().equals((Object)Msg.INVOCATION_MISSING_TARGET)));
    }

    @Test
    public void testINVOCATION_WRONG_PARAM_COUNT() {
        Definitions definitions = this.utilDefinitions("INVOCATION_WRONG_PARAM_COUNT.dmn", "INVOCATION_WRONG_PARAM_COUNT");
        List validate = validator.validateModel(definitions);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessage().equals((Object)Msg.INVOCATION_WRONG_PARAM_COUNT)));
    }

    @Test
    public void testITEMCOMP_DUPLICATED() {
        Definitions definitions = this.utilDefinitions("ITEMCOMP_DUPLICATED.dmn", "ITEMCOMP_DUPLICATED");
        List validate = validator.validateModel(definitions);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessage().equals((Object)Msg.ITEMCOMP_DUPLICATED)));
    }

    @Test
    public void testITEMDEF_NOT_UNIQUE() {
        Definitions definitions = this.utilDefinitions("ITEMDEF_NOT_UNIQUE.dmn", "ITEMDEF_NOT_UNIQUE");
        List validate = validator.validateModel(definitions);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessage().equals((Object)Msg.ITEMDEF_NOT_UNIQUE)));
    }

    @Test
    public void testITEMDEF_NOT_UNIQUE_DROOLS_1450() {
        Definitions definitions = this.utilDefinitions("ITEMDEF_NOT_UNIQUE_DROOLS-1450.dmn", "ITEMDEF_NOT_UNIQUE");
        List validate = validator.validateModel(definitions);
        Assert.assertFalse((boolean)validate.stream().anyMatch(p -> p.getMessage().equals((Object)Msg.ITEMDEF_NOT_UNIQUE)));
    }

    @Test
    public void testNAME_INVALID() {
        Definitions definitions = this.utilDefinitions("NAME_INVALID.dmn", "NAME_INVALID");
        List validate = validator.validateModel(definitions);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessage().equals((Object)Msg.NAME_INVALID)));
    }

    @Test
    public void testRELATION_DUP_COLUMN() {
        Definitions definitions = this.utilDefinitions("RELATION_DUP_COLUMN.dmn", "RELATION_DUP_COLUMN");
        List validate = validator.validateModel(definitions);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessage().equals((Object)Msg.RELATION_DUP_COLUMN)));
    }

    @Test
    public void testRELATION_ROW_CELL_NOTLITERAL() {
        Definitions definitions = this.utilDefinitions("RELATION_ROW_CELL_NOTLITERAL.dmn", "RELATION_ROW_CELL_NOTLITERAL");
        List validate = validator.validateModel(definitions);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessage().equals((Object)Msg.RELATION_ROW_CELL_NOTLITERAL)));
    }

    @Test
    public void testRELATION_ROW_CELLCOUNTMISMATCH() {
        Definitions definitions = this.utilDefinitions("RELATION_ROW_CELLCOUNTMISMATCH.dmn", "RELATION_ROW_CELLCOUNTMISMATCH");
        List validate = validator.validateModel(definitions);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessage().equals((Object)Msg.RELATION_ROW_CELLCOUNTMISMATCH)));
    }

    @Test
    public void testREQAUTH_NOT_KNOWLEDGESOURCE() {
        Definitions definitions = this.utilDefinitions("REQAUTH_NOT_KNOWLEDGESOURCE.dmn", "REQAUTH_NOT_KNOWLEDGESOURCE");
        List validate = validator.validateModel(definitions);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessage().equals((Object)Msg.REQAUTH_NOT_KNOWLEDGESOURCE)));
    }

    @Test
    public void testREQAUTH_NOT_KNOWLEDGESOURCEbis() {
        Definitions definitions = this.utilDefinitions("REQAUTH_NOT_KNOWLEDGESOURCEbis.dmn", "REQAUTH_NOT_KNOWLEDGESOURCEbis");
        List validate = validator.validateModel(definitions);
        Assert.assertTrue((validate.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTYPEREF_NO_FEEL_TYPE() {
        Definitions definitions = this.utilDefinitions("TYPEREF_NO_FEEL_TYPE.dmn", "TYPEREF_NO_FEEL_TYPE");
        List validate = validator.validateModel(definitions);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessage().equals((Object)Msg.TYPEREF_NO_FEEL_TYPE)));
    }

    @Test
    public void testTYPEREF_NOT_FEEL_NOT_DEF() {
        Definitions definitions = this.utilDefinitions("TYPEREF_NOT_FEEL_NOT_DEF.dmn", "TYPEREF_NOT_FEEL_NOT_DEF");
        List validate = validator.validateModel(definitions);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessage().equals((Object)Msg.TYPEREF_NOT_FEEL_NOT_DEF)));
    }

    @Test
    public void testTYPEREF_NOT_FEEL_NOT_DEF_valid() {
        Definitions definitions = this.utilDefinitions("TYPEREF_NOT_FEEL_NOT_DEF_valid.dmn", "TYPEREF_NOT_FEEL_NOT_DEF_valid");
        List validate = validator.validateModel(definitions);
        validate.forEach(m -> System.out.println(m.getMessage()));
        Assert.assertTrue((boolean)validate.stream().noneMatch(p -> p.getMessage().equals((Object)Msg.TYPEREF_NOT_FEEL_NOT_DEF)));
    }

    @Test
    public void testNAME_INVALID_empty_name() {
        Assert.assertFalse((boolean)FEELParser.isVariableNameValid(null));
        Assert.assertFalse((boolean)FEELParser.isVariableNameValid((String)""));
        Definitions definitions = this.utilDefinitions("DROOLS-1447.dmn", "DROOLS-1447");
        List validate = validator.validateModel(definitions);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessage().equals((Object)Msg.NAME_INVALID)));
    }
}

