/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.drools.core.util.IoUtils;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.event.rule.DefaultRuleRuntimeEventListener;
import org.kie.api.event.rule.ObjectInsertedEvent;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.dmn.model.v1_1.DMNModelInstrumentedBase;
import org.kie.dmn.model.v1_1.Definitions;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.Msg;
import org.kie.dmn.validation.ValidationMsg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class DMNValidatorImpl
implements DMNValidator {
    public static Logger LOG = LoggerFactory.getLogger(DMNValidatorImpl.class);
    static Schema schema;
    private Optional<KieContainer> kieContainer;
    private List<ValidationMsg> failedInitMsg;

    public DMNValidatorImpl() {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        ReleaseId rid = ks.newReleaseId("org.kie", "kie-dmn-validation", "1");
        kfs.generateAndWritePomXML(rid);
        try {
            kfs.write("src/main/resources/rules.drl", IoUtils.readBytesFromInputStream((InputStream)DMNValidatorImpl.class.getResourceAsStream("/rules.drl")));
        }
        catch (IOException e) {
            LOG.error("Unable to read embedded DMN validation rule file.", (Throwable)e);
            this.failedInitMsg.add(new ValidationMsg(ValidationMsg.Severity.ERROR, Msg.FAILED_VALIDATOR, e.getMessage()));
        }
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        Results results = kieBuilder.getResults();
        for (Message m2 : results.getMessages(new Message.Level[]{Message.Level.ERROR, Message.Level.WARNING})) {
            if (m2.getLevel() == Message.Level.ERROR) {
                LOG.error("{}", (Object)m2);
                continue;
            }
            if (m2.getLevel() != Message.Level.WARNING) continue;
            LOG.warn("{}", (Object)m2);
        }
        if (results.hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            LOG.error("Errors while compiling embedded DMN validation rules.");
            results.getMessages().stream().map(m -> new ValidationMsg(ValidationMsg.Severity.ERROR, Msg.FAILED_VALIDATOR, m)).forEach(vm -> this.failedInitMsg.add((ValidationMsg)vm));
            this.kieContainer = Optional.empty();
        } else {
            this.kieContainer = Optional.of(ks.newKieContainer(rid));
        }
    }

    @Override
    public void dispose() {
        this.kieContainer.ifPresent(KieContainer::dispose);
    }

    @Override
    public List<ValidationMsg> validateSchema(File xmlFile) {
        ArrayList<ValidationMsg> problems = new ArrayList<ValidationMsg>();
        StreamSource s = new StreamSource(xmlFile);
        try {
            schema.newValidator().validate(s);
        }
        catch (IOException | SAXException e) {
            problems.add(new ValidationMsg(ValidationMsg.Severity.ERROR, Msg.FAILED_XML_VALIDATION, e));
        }
        return problems;
    }

    @Override
    public List<ValidationMsg> validateModel(Definitions dmnModel) {
        if (!this.kieContainer.isPresent()) {
            return this.failedInitMsg;
        }
        StatelessKieSession kieSession = this.kieContainer.get().newStatelessKieSession();
        final ArrayList<ValidationMsg> problems = new ArrayList<ValidationMsg>();
        kieSession.addEventListener((RuleRuntimeEventListener)new DefaultRuleRuntimeEventListener(){

            public void objectInserted(ObjectInsertedEvent event) {
                if (event.getObject() instanceof ValidationMsg) {
                    problems.add((ValidationMsg)event.getObject());
                }
            }
        });
        kieSession.execute((Iterable)DMNValidatorImpl.allChildren((DMNModelInstrumentedBase)dmnModel).collect(Collectors.toList()));
        return problems;
    }

    public static <T> Stream<T> allChildren(DMNModelInstrumentedBase root, Class<T> clazz) {
        return DMNValidatorImpl.allChildren(root).filter(dmn -> clazz.isInstance(dmn));
    }

    public static Stream<DMNModelInstrumentedBase> allChildren(DMNModelInstrumentedBase root) {
        return Stream.concat(Stream.of(root), root.getChildren().stream().flatMap(DMNValidatorImpl::allChildren));
    }

    @Deprecated
    public static List<DMNModelInstrumentedBase> allChildrenClassic(DMNModelInstrumentedBase root) {
        ArrayList<DMNModelInstrumentedBase> result = new ArrayList<DMNModelInstrumentedBase>();
        for (DMNModelInstrumentedBase c : root.getChildren()) {
            result.add(c);
            result.addAll(DMNValidatorImpl.allChildrenClassic(c));
        }
        return result;
    }

    static {
        try {
            schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }
}

