/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.validation.AbstractValidatorTest;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.ValidatorUtil;

public class ValidatorBusinessContextTest
extends AbstractValidatorTest {
    @Test
    public void testORG_UNIT_DECISION_MADE_WRONG_TYPE_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("businesscontext/ORG_UNIT_DECISION_MADE_WRONG_TYPE.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
            Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
        }
    }

    @Test
    public void testORG_UNIT_DECISION_MADE_WRONG_TYPE_FileInput() {
        List validate = validator.validate(this.getFile("businesscontext/ORG_UNIT_DECISION_MADE_WRONG_TYPE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
    }

    @Test
    public void testORG_UNIT_DECISION_MADE_WRONG_TYPE_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("businesscontext/ORG_UNIT_DECISION_MADE_WRONG_TYPE.dmn", "https://github.com/kiegroup/kie-dmn", "ORG_UNIT_DECISION_MADE_WRONG_TYPE"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
    }

    @Test
    public void testORG_UNIT_DECISION_OWNED_WRONG_TYPE_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("businesscontext/ORG_UNIT_DECISION_OWNED_WRONG_TYPE.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
            Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
        }
    }

    @Test
    public void testORG_UNIT_DECISION_OWNED_WRONG_TYPE_FileInput() {
        List validate = validator.validate(this.getFile("businesscontext/ORG_UNIT_DECISION_OWNED_WRONG_TYPE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
    }

    @Test
    public void testORG_UNIT_DECISION_OWNED_WRONG_TYPE_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("businesscontext/ORG_UNIT_DECISION_OWNED_WRONG_TYPE.dmn", "https://github.com/kiegroup/kie-dmn", "ORG_UNIT_DECISION_OWNED_WRONG_TYPE"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
    }

    @Test
    public void testPERF_INDICATOR_IMP_DECISION_WRONG_TYPE_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("businesscontext/PERF_INDICATOR_IMP_DECISION_WRONG_TYPE.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
            Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
        }
    }

    @Test
    public void testPERF_INDICATOR_IMP_DECISION_WRONG_TYPE_FileInput() {
        List validate = validator.validate(this.getFile("businesscontext/PERF_INDICATOR_IMP_DECISION_WRONG_TYPE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
    }

    @Test
    public void testPERF_INDICATOR_IMP_DECISION_WRONG_TYPE_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("businesscontext/PERF_INDICATOR_IMP_DECISION_WRONG_TYPE.dmn", "https://github.com/kiegroup/kie-dmn", "PERF_INDICATOR_IMP_DECISION_WRONG_TYPE"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
    }
}

