/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;

public class Check1stNFViolationTest
extends AbstractDTAnalysisTest {
    @Test
    public void testCheck1stNFViolation() {
        List validate = validator.validate(this.getReader("DT1stNFViolation.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysisDuplicate = this.getAnalysis(validate, "_053034d5-0e1f-4c4a-8513-ab3c6ba538db");
        Assert.assertThat((Object)analysisDuplicate.is1stNFViolation(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)analysisDuplicate.getDuplicateRulesTuples(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)analysisDuplicate.getDuplicateRulesTuples(), (Matcher)Matchers.contains((Object[])Collections.singletonList(Arrays.asList(1, 2)).toArray()));
        Assert.assertTrue((String)"It should contain at DMNMessage for the 1st NF Violation", (boolean)validate.stream().anyMatch(p -> p.getSourceId().equals("_053034d5-0e1f-4c4a-8513-ab3c6ba538db") && p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_1STNFVIOLATION)));
        DTAnalysis analysisFIRST = this.getAnalysis(validate, "_1ca6acde-c1d4-4c50-8e21-f3b11e106f3d");
        Assert.assertThat((Object)analysisFIRST.is1stNFViolation(), (Matcher)Matchers.is((Object)true));
        Assert.assertTrue((String)"It should contain at DMNMessage for the 1st NF Violation", (boolean)validate.stream().anyMatch(p -> p.getSourceId().equals("_1ca6acde-c1d4-4c50-8e21-f3b11e106f3d") && p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_1STNFVIOLATION)));
        DTAnalysis analysisRULE_ORDER = this.getAnalysis(validate, "_03522945-b520-4b45-ac5e-ef3cbd7f1eaf");
        Assert.assertThat((Object)analysisRULE_ORDER.is1stNFViolation(), (Matcher)Matchers.is((Object)true));
        Assert.assertTrue((String)"It should contain at DMNMessage for the 1st NF Violation", (boolean)validate.stream().anyMatch(p -> p.getSourceId().equals("_03522945-b520-4b45-ac5e-ef3cbd7f1eaf") && p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_1STNFVIOLATION)));
    }

    @Test
    public void testCheck1stNFViolationB() {
        List validate = validator.validate(this.getReader("DT1stNFViolationB.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysisDuplicate = this.getAnalysis(validate, "_053034d5-0e1f-4c4a-8513-ab3c6ba538db");
        Assert.assertThat((Object)analysisDuplicate.is1stNFViolation(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)analysisDuplicate.getDuplicateRulesTuples(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)analysisDuplicate.getDuplicateRulesTuples(), (Matcher)Matchers.contains((Object[])Collections.singletonList(Arrays.asList(1, 2)).toArray()));
        Assert.assertTrue((String)"It should contain at DMNMessage for the 1st NF Violation", (boolean)validate.stream().anyMatch(p -> p.getSourceId().equals("_053034d5-0e1f-4c4a-8513-ab3c6ba538db") && p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_1STNFVIOLATION)));
    }
}

