/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.printer.PrettyPrinterConfiguration;
import java.util.HashMap;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.validation.AbstractValidatorTest;
import org.kie.dmn.validation.ValidatorUtil;
import org.kie.dmn.validation.dtanalysis.DMNDTAnalysisMessage;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.kie.dmn.validation.dtanalysis.model.Hyperrectangle;
import org.kie.dmn.validation.dtanalysis.model.Overlap;
import org.kie.dmn.validation.dtanalysis.utils.DTAnalysisMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDTAnalysisTest
extends AbstractValidatorTest {
    public static final Logger LOG = LoggerFactory.getLogger(AbstractDTAnalysisTest.class);

    protected DTAnalysis getAnalysis(List<DMNMessage> dmnMessages, String id) {
        Assert.assertThat((String)"Expected to find DTAnalysis but messages are empty.", dmnMessages, (Matcher)Matchers.not((Matcher)Matchers.empty()));
        if (LOG.isDebugEnabled()) {
            LOG.debug("List<DMNMessage> dmnMessages: \n{}", (Object)ValidatorUtil.formatMessages(dmnMessages));
        }
        HashMap<String, DTAnalysis> as = new HashMap<String, DTAnalysis>();
        for (DMNMessage dmnMessage : dmnMessages) {
            if (!dmnMessage.getSourceId().equals(id) || !(dmnMessage instanceof DMNDTAnalysisMessage)) continue;
            DMNDTAnalysisMessage dmndtAnalysisMessage = (DMNDTAnalysisMessage)dmnMessage;
            if (as.containsKey(id)) {
                Assert.assertThat((String)"Inconsistency detected", as.get(id), (Matcher)CoreMatchers.is((Object)dmndtAnalysisMessage.getAnalysis()));
                continue;
            }
            as.put(id, dmndtAnalysisMessage.getAnalysis());
        }
        DTAnalysis analysis = (DTAnalysis)as.get(id);
        Assert.assertThat((String)"Null analysis value for key.", (Object)analysis, (Matcher)Matchers.notNullValue());
        this.debugAnalysis(analysis);
        return analysis;
    }

    protected void debugValidatorMsg(List<DMNMessage> dmnMessages) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        StringBuilder sbGaps = new StringBuilder("Validator messages:\n");
        for (DMNMessage msg : dmnMessages) {
            sbGaps.append(String.format("%8s %s", msg.getLevel(), msg.getMessage()));
            sbGaps.append("\n");
        }
        LOG.debug(sbGaps.toString());
    }

    protected void debugAnalysis(DTAnalysis analysis) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        StringBuilder sbGaps = new StringBuilder("\nGaps:\n");
        for (Hyperrectangle gap : analysis.getGaps()) {
            sbGaps.append(gap.toString());
            sbGaps.append("\n");
        }
        LOG.debug(sbGaps.toString());
        PrettyPrinterConfiguration prettyPrintConfig = new PrettyPrinterConfiguration();
        prettyPrintConfig.setColumnAlignFirstMethodChain(true);
        prettyPrintConfig.setColumnAlignParameters(true);
        Expression printGaps = DTAnalysisMeta.printGaps(analysis);
        LOG.debug("\n" + printGaps.toString(prettyPrintConfig));
        StringBuilder sbOverlaps = new StringBuilder("\nOverlaps:\n");
        for (Overlap overlap : analysis.getOverlaps()) {
            sbOverlaps.append(overlap.toString());
            sbOverlaps.append("\n");
        }
        LOG.debug(sbOverlaps.toString());
        Expression printOverlaps = DTAnalysisMeta.printOverlaps(analysis);
        LOG.debug("\n" + printOverlaps.toString(prettyPrintConfig));
    }
}

