/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.model.Bound;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.kie.dmn.validation.dtanalysis.model.Hyperrectangle;
import org.kie.dmn.validation.dtanalysis.model.Interval;
import org.kie.dmn.validation.dtanalysis.model.MaskedRule;
import org.kie.dmn.validation.dtanalysis.model.MisleadingRule;
import org.kie.dmn.validation.dtanalysis.model.Overlap;

public class StringWithoutEnumNoGapTest
extends AbstractDTAnalysisTest {
    @Test
    public void test() {
        List validate = validator.validate(this.getReader("stringWithoutEnumNoGap.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        Assert.assertThat((Object)validate, (Matcher)Matchers.hasSize((int)7));
        StringWithoutEnumNoGapTest.debugValidatorMsg(validate);
        DTAnalysis analysis = StringWithoutEnumNoGapTest.getAnalysis(validate, "_8b48d1c9-265c-47aa-9378-7f11d55dfe55");
        Assert.assertThat((Object)analysis.getGaps(), (Matcher)Matchers.hasSize((int)0));
        Assert.assertThat((Object)analysis.getOverlaps(), (Matcher)Matchers.hasSize((int)2));
        List<Overlap> overlaps = Arrays.asList(new Overlap(Arrays.asList(1, 3), new Hyperrectangle(2, Arrays.asList(Interval.newFromBounds((Bound)new Bound((Comparable)((Object)"EU"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)((Object)"EU"), Range.RangeBoundary.CLOSED, null)), Interval.newFromBounds((Bound)new Bound((Comparable)new BigDecimal("18"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound(Interval.POS_INF, Range.RangeBoundary.CLOSED, null))))), new Overlap(Arrays.asList(3, 2), new Hyperrectangle(2, Arrays.asList(Interval.newFromBounds((Bound)new Bound((Comparable)((Object)"US"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)((Object)"US"), Range.RangeBoundary.CLOSED, null)), Interval.newFromBounds((Bound)new Bound((Comparable)new BigDecimal("21"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound(Interval.POS_INF, Range.RangeBoundary.CLOSED, null))))));
        Assert.assertThat(overlaps, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)analysis.getOverlaps(), (Matcher)Matchers.contains((Object[])overlaps.toArray()));
        Assert.assertThat((Object)analysis.getMaskedRules(), (Matcher)Matchers.hasSize((int)2));
        List<MaskedRule> maskedRules = Arrays.asList(new MaskedRule(1, 3), new MaskedRule(2, 3));
        Assert.assertThat(maskedRules, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)analysis.getMaskedRules(), (Matcher)Matchers.contains((Object[])maskedRules.toArray()));
        Assert.assertTrue((String)"It should contain DMNMessage for the MaskedRule", (boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_MASKED_RULE)));
        Assert.assertThat((Object)analysis.getMisleadingRules(), (Matcher)Matchers.hasSize((int)2));
        List<MisleadingRule> misleadingRules = Arrays.asList(new MisleadingRule(3, 1), new MisleadingRule(3, 2));
        Assert.assertThat(misleadingRules, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)analysis.getMisleadingRules(), (Matcher)Matchers.contains((Object[])misleadingRules.toArray()));
        Assert.assertTrue((String)"It should contain DMNMessage for the MisleadingRule", (boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_MISLEADING_RULE)));
    }
}

