/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.kie.dmn.feel.lang.types.impl.ComparablePeriod;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.model.Bound;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.kie.dmn.validation.dtanalysis.model.Hyperrectangle;
import org.kie.dmn.validation.dtanalysis.model.Interval;
import org.kie.dmn.validation.dtanalysis.model.Overlap;

public class BuiltinAndOtherValuesTest
extends AbstractDTAnalysisTest {
    @Test
    public void testComplexDTdates() {
        List validate = validator.validate(this.getReader("complexDTdates.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = BuiltinAndOtherValuesTest.getAnalysis(validate, "_a8a4362e-9f2d-4051-9bd6-e7356244f6b7");
        this.checkComplexDTDates(analysis);
    }

    @Test
    public void testComplexDTdatesV2() {
        List validate = validator.validate(this.getReader("complexDTdatesV2.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = BuiltinAndOtherValuesTest.getAnalysis(validate, "_a8a4362e-9f2d-4051-9bd6-e7356244f6b7");
        this.checkComplexDTDates(analysis);
    }

    private void checkComplexDTDates(DTAnalysis analysis) {
        MatcherAssert.assertThat((Object)analysis.getGaps(), (Matcher)Matchers.hasSize((int)2));
        List<Hyperrectangle> gaps = Arrays.asList(new Hyperrectangle(1, Arrays.asList(Interval.newFromBounds((Bound)new Bound((Comparable)LocalDate.parse("2019-03-31"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)LocalDate.parse("2019-03-31"), Range.RangeBoundary.CLOSED, null)))), new Hyperrectangle(1, Arrays.asList(Interval.newFromBounds((Bound)new Bound((Comparable)LocalDate.parse("2019-12-31"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)LocalDate.parse("2019-12-31"), Range.RangeBoundary.CLOSED, null)))));
        MatcherAssert.assertThat(gaps, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)analysis.getGaps(), (Matcher)Matchers.contains((Object[])gaps.toArray()));
        MatcherAssert.assertThat((Object)analysis.getOverlaps(), (Matcher)Matchers.hasSize((int)1));
        List<Overlap> overlaps = Arrays.asList(new Overlap(Arrays.asList(2, 3), new Hyperrectangle(1, Arrays.asList(Interval.newFromBounds((Bound)new Bound((Comparable)LocalDate.parse("2019-06-30"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)LocalDate.parse("2019-06-30"), Range.RangeBoundary.CLOSED, null))))));
        MatcherAssert.assertThat(overlaps, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)analysis.getOverlaps(), (Matcher)Matchers.contains((Object[])overlaps.toArray()));
    }

    @Test
    public void testWeirdPosNeg() {
        List validate = validator.validate(this.getReader("weirdPosNeg.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = BuiltinAndOtherValuesTest.getAnalysis(validate, "_54ae95be-6866-4dc1-8c10-1c5a4dd15c93");
        MatcherAssert.assertThat((Object)analysis.getGaps(), (Matcher)Matchers.hasSize((int)1));
        List<Hyperrectangle> gaps = Arrays.asList(new Hyperrectangle(1, Arrays.asList(Interval.newFromBounds((Bound)new Bound((Comparable)new BigDecimal("0"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)new BigDecimal("0"), Range.RangeBoundary.CLOSED, null)))));
        MatcherAssert.assertThat(gaps, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)analysis.getGaps(), (Matcher)Matchers.contains((Object[])gaps.toArray()));
        MatcherAssert.assertThat((Object)analysis.getOverlaps(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testWeirdYMduration() {
        List validate = validator.validate(this.getReader("weirdYMduration.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = BuiltinAndOtherValuesTest.getAnalysis(validate, "_fe7d267b-d770-461e-8300-e09981147341");
        MatcherAssert.assertThat((Object)analysis.getGaps(), (Matcher)Matchers.hasSize((int)1));
        List<Hyperrectangle> gaps = Arrays.asList(new Hyperrectangle(1, Arrays.asList(Interval.newFromBounds((Bound)new Bound((Comparable)ComparablePeriod.parse((CharSequence)"P1M"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)ComparablePeriod.parse((CharSequence)"P1M"), Range.RangeBoundary.CLOSED, null)))));
        MatcherAssert.assertThat(gaps, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)analysis.getGaps(), (Matcher)Matchers.contains((Object[])gaps.toArray()));
        MatcherAssert.assertThat((Object)analysis.getOverlaps(), (Matcher)Matchers.hasSize((int)0));
    }
}

