/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.validation.dtanalysis.model.Bound;
import org.kie.dmn.validation.dtanalysis.model.Domain;
import org.kie.dmn.validation.dtanalysis.model.Interval;

public class IntervalTest {
    @Test
    public void testFlatten() {
        Interval a = new Interval(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(3), Range.RangeBoundary.OPEN, 0, 0);
        Interval b = new Interval(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2), Range.RangeBoundary.CLOSED, 0, 0);
        Interval c = new Interval(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(4), Range.RangeBoundary.CLOSED, 0, 0);
        List result = Interval.flatten(Arrays.asList(c, b, a));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.contains((Object[])new Interval[]{new Interval(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(4), Range.RangeBoundary.CLOSED, 0, 0)}));
    }

    @Test
    public void testFlatten2() {
        Interval a = new Interval(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(3), Range.RangeBoundary.OPEN, 0, 0);
        Interval b = new Interval(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2), Range.RangeBoundary.CLOSED, 0, 0);
        Interval c = new Interval(Range.RangeBoundary.OPEN, (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(4), Range.RangeBoundary.CLOSED, 0, 0);
        List result = Interval.flatten(Arrays.asList(c, b, a));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.contains((Object[])new Interval[]{new Interval(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(3), Range.RangeBoundary.OPEN, 0, 0), new Interval(Range.RangeBoundary.OPEN, (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(4), Range.RangeBoundary.CLOSED, 0, 0)}));
    }

    @Test
    public void testFlatten3() {
        Interval a = new Interval(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(3), Range.RangeBoundary.CLOSED, 0, 0);
        Interval b = new Interval(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2), Range.RangeBoundary.CLOSED, 0, 0);
        Interval c = new Interval(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(4), Range.RangeBoundary.CLOSED, 0, 0);
        List result = Interval.flatten(Arrays.asList(c, b, a));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.contains((Object[])new Interval[]{new Interval(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(4), Range.RangeBoundary.CLOSED, 0, 0)}));
    }

    @Test
    public void testInvertOverDomain() {
        Interval a = new Interval(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(3), Range.RangeBoundary.OPEN, 1, 2);
        Interval domain = new Interval(Range.RangeBoundary.CLOSED, Interval.NEG_INF, Interval.POS_INF, Range.RangeBoundary.CLOSED, 0, 0);
        List result = Interval.invertOverDomain((Interval)a, (Interval)domain);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.hasSize((int)2));
        IntervalTest.assertInterval((Interval)result.get(0), Range.RangeBoundary.CLOSED, Interval.NEG_INF, Integer.valueOf(0), Range.RangeBoundary.OPEN, 1, 2);
        IntervalTest.assertInterval((Interval)result.get(1), Range.RangeBoundary.CLOSED, Integer.valueOf(3), Interval.POS_INF, Range.RangeBoundary.CLOSED, 1, 2);
    }

    @Test
    public void testInvertOverDomain2() {
        Interval a = new Interval(Range.RangeBoundary.CLOSED, (Comparable)((Object)"i"), (Comparable)((Object)"o"), Range.RangeBoundary.OPEN, 9, 8);
        Interval domain = new Interval(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"u"), Range.RangeBoundary.CLOSED, 0, 0);
        List result = Interval.invertOverDomain((Interval)a, (Interval)domain);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.hasSize((int)2));
        IntervalTest.assertInterval((Interval)result.get(0), Range.RangeBoundary.CLOSED, "a", "i", Range.RangeBoundary.OPEN, 9, 8);
        IntervalTest.assertInterval((Interval)result.get(1), Range.RangeBoundary.CLOSED, "o", "u", Range.RangeBoundary.CLOSED, 9, 8);
    }

    private static void assertInterval(Interval interval, Range.RangeBoundary lowType, Comparable<?> lowValue, Comparable<?> hiValue, Range.RangeBoundary hiType, int rule, int col) {
        MatcherAssert.assertThat((Object)interval.getLowerBound(), (Matcher)Matchers.is((Object)new Bound(lowValue, lowType, interval)));
        MatcherAssert.assertThat((Object)interval.getUpperBound(), (Matcher)Matchers.is((Object)new Bound(hiValue, hiType, interval)));
        MatcherAssert.assertThat((Object)interval.getRule(), (Matcher)Matchers.is((Object)rule));
        MatcherAssert.assertThat((Object)interval.getCol(), (Matcher)Matchers.is((Object)col));
    }

    @Test
    public void testHumanFriendlyContinuous() {
        Interval domainInterval = new Interval(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100), Range.RangeBoundary.CLOSED, 0, 0);
        DummyDomain domain = new DummyDomain(domainInterval, Collections.emptyList());
        MatcherAssert.assertThat((Object)new Interval(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(100), Range.RangeBoundary.CLOSED, 0, 0).asHumanFriendly((Domain)domain), (Matcher)Matchers.startsWith((String)">="));
        MatcherAssert.assertThat((Object)new Interval(Range.RangeBoundary.OPEN, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(100), Range.RangeBoundary.CLOSED, 0, 0).asHumanFriendly((Domain)domain), (Matcher)Matchers.startsWith((String)">"));
        MatcherAssert.assertThat((Object)new Interval(Range.RangeBoundary.OPEN, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(100), Range.RangeBoundary.CLOSED, 0, 0).asHumanFriendly((Domain)domain), (Matcher)Matchers.not((Matcher)Matchers.startsWith((String)">=")));
        MatcherAssert.assertThat((Object)new Interval(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(99), Range.RangeBoundary.CLOSED, 0, 0).asHumanFriendly((Domain)domain), (Matcher)Matchers.startsWith((String)"<="));
        MatcherAssert.assertThat((Object)new Interval(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(99), Range.RangeBoundary.OPEN, 0, 0).asHumanFriendly((Domain)domain), (Matcher)Matchers.startsWith((String)"<"));
        MatcherAssert.assertThat((Object)new Interval(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(99), Range.RangeBoundary.OPEN, 0, 0).asHumanFriendly((Domain)domain), (Matcher)Matchers.not((Matcher)Matchers.startsWith((String)"<=")));
    }

    public static class DummyDomain
    implements Domain {
        private final Interval domainMinMax;
        private final List discreteValues;

        public DummyDomain(Interval domainMinMax, List discreteValues) {
            this.domainMinMax = domainMinMax;
            this.discreteValues = discreteValues;
        }

        public Bound<?> getMin() {
            return this.domainMinMax.getLowerBound();
        }

        public Bound<?> getMax() {
            return this.domainMinMax.getUpperBound();
        }

        public Interval getDomainMinMax() {
            return this.domainMinMax;
        }

        public List getDiscreteValues() {
            return Collections.unmodifiableList(this.discreteValues);
        }

        public boolean isDiscreteDomain() {
            return this.discreteValues != null && !this.discreteValues.isEmpty();
        }
    }
}

