/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.model.Bound;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.kie.dmn.validation.dtanalysis.model.Hyperrectangle;
import org.kie.dmn.validation.dtanalysis.model.Interval;
import org.kie.dmn.validation.dtanalysis.model.MaskedRule;
import org.kie.dmn.validation.dtanalysis.model.Overlap;

public class MaskTest
extends AbstractDTAnalysisTest {
    @Test
    public void test_MaskBasic() {
        List validate = validator.validate(this.getReader("MaskBasic.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = MaskTest.getAnalysis(validate, "_BA703D04-803A-44AA-8A31-F5EEDD4FD54E");
        MatcherAssert.assertThat((Object)analysis.getGaps(), (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat((Object)analysis.getOverlaps(), (Matcher)Matchers.hasSize((int)1));
        List<Overlap> overlaps = Arrays.asList(new Overlap(Arrays.asList(2, 1), new Hyperrectangle(1, Arrays.asList(Interval.newFromBounds((Bound)new Bound((Comparable)new BigDecimal("18"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound(Interval.POS_INF, Range.RangeBoundary.CLOSED, null))))));
        MatcherAssert.assertThat(overlaps, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)analysis.getOverlaps(), (Matcher)Matchers.contains((Object[])overlaps.toArray()));
        MatcherAssert.assertThat((Object)analysis.getMaskedRules(), (Matcher)Matchers.hasSize((int)1));
        List<MaskedRule> maskedRules = Arrays.asList(new MaskedRule(1, 2));
        MatcherAssert.assertThat(maskedRules, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)analysis.getMaskedRules(), (Matcher)Matchers.contains((Object[])maskedRules.toArray()));
        Assert.assertTrue((String)"It should contain at least 1 DMNMessage for the MaskedRule", (boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_MASKED_RULE)));
        Assert.assertTrue((String)"It should not contain DMNMessage for the MisleadingRule", (boolean)validate.stream().noneMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_MISLEADING_RULE)));
    }

    @Test
    public void test_MaskTest() {
        List validate = validator.validate(this.getReader("MaskTest.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = MaskTest.getAnalysis(validate, "_BA703D04-803A-44AA-8A31-F5EEDD4FD54E");
        MatcherAssert.assertThat((Object)analysis.getGaps(), (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat((Object)analysis.getOverlaps(), (Matcher)Matchers.hasSize((int)1));
        List<Overlap> overlaps = Arrays.asList(new Overlap(Arrays.asList(2, 1), new Hyperrectangle(3, Arrays.asList(Interval.newFromBounds((Bound)new Bound((Comparable)new BigDecimal("18"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound(Interval.POS_INF, Range.RangeBoundary.CLOSED, null)), Interval.newFromBounds((Bound)new Bound((Comparable)((Object)"L"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)((Object)"M"), Range.RangeBoundary.CLOSED, null)), Interval.newFromBounds((Bound)new Bound((Comparable)Boolean.valueOf(true), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)Boolean.valueOf(true), Range.RangeBoundary.CLOSED, null))))));
        MatcherAssert.assertThat(overlaps, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)analysis.getOverlaps(), (Matcher)Matchers.contains((Object[])overlaps.toArray()));
        MatcherAssert.assertThat((Object)analysis.getMaskedRules(), (Matcher)Matchers.hasSize((int)1));
        List<MaskedRule> maskedRules = Arrays.asList(new MaskedRule(1, 2));
        MatcherAssert.assertThat(maskedRules, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)analysis.getMaskedRules(), (Matcher)Matchers.contains((Object[])maskedRules.toArray()));
        Assert.assertTrue((String)"It should contain at least 1 DMNMessage for the MaskedRule", (boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_MASKED_RULE)));
        Assert.assertTrue((String)"It should not contain DMNMessage for the MisleadingRule", (boolean)validate.stream().noneMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_MISLEADING_RULE)));
    }
}

