/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.GapsXYTest;
import org.kie.dmn.validation.dtanalysis.model.Bound;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.kie.dmn.validation.dtanalysis.model.Hyperrectangle;
import org.kie.dmn.validation.dtanalysis.model.Interval;

public class NullTest
extends AbstractDTAnalysisTest {
    @Test
    public void testNullBooleanBefore() {
        List validate = validator.validate(this.getReader("NullBooleanBefore.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        this.checkNullBoolean(validate);
    }

    @Test
    public void testNullBooleanAfter() {
        List validate = validator.validate(this.getReader("NullBooleanAfter.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        this.checkNullBoolean(validate);
    }

    private void checkNullBoolean(List<DMNMessage> validate) {
        DTAnalysis analysis = NullTest.getAnalysis(validate, "_76FABA99-C6D0-4C83-81BF-92E807DBDEF8");
        MatcherAssert.assertThat((Object)analysis.getGaps(), (Matcher)Matchers.hasSize((int)1));
        List<Hyperrectangle> gaps = Arrays.asList(new Hyperrectangle(1, Arrays.asList(Interval.newFromBounds((Bound)new Bound((Comparable)Boolean.valueOf(true), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)Boolean.valueOf(true), Range.RangeBoundary.CLOSED, null)))));
        MatcherAssert.assertThat(gaps, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)analysis.getGaps(), (Matcher)Matchers.contains((Object[])gaps.toArray()));
        MatcherAssert.assertThat((Object)analysis.getOverlaps(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testNullNumberBefore() {
        List validate = validator.validate(this.getReader("NullNumberBefore.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        this.checkNullNumber(validate);
    }

    @Test
    public void testNullNumberAfter() {
        List validate = validator.validate(this.getReader("NullNumberAfter.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        this.checkNullNumber(validate);
    }

    private void checkNullNumber(List<DMNMessage> validate) {
        DTAnalysis analysis = NullTest.getAnalysis(validate, "_76FABA99-C6D0-4C83-81BF-92E807DBDEF8");
        MatcherAssert.assertThat((Object)analysis.getGaps(), (Matcher)Matchers.hasSize((int)1));
        List<Hyperrectangle> gaps = Arrays.asList(new Hyperrectangle(1, Arrays.asList(Interval.newFromBounds((Bound)new Bound((Comparable)new BigDecimal("0"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound(Interval.POS_INF, Range.RangeBoundary.CLOSED, null)))));
        MatcherAssert.assertThat(gaps, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)analysis.getGaps(), (Matcher)Matchers.contains((Object[])gaps.toArray()));
        MatcherAssert.assertThat((Object)analysis.getOverlaps(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testGapsXYv2WithNull() {
        List validate = validator.validate(this.getReader("GapsXYv2WithNull.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        GapsXYTest.checkAnalysis(validate);
    }
}

