/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.printer.configuration.ConfigurationOption;
import com.github.javaparser.printer.configuration.DefaultConfigurationOption;
import com.github.javaparser.printer.configuration.DefaultPrinterConfiguration;
import com.github.javaparser.printer.configuration.PrinterConfiguration;
import java.util.HashMap;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.validation.AbstractValidatorTest;
import org.kie.dmn.validation.ValidatorUtil;
import org.kie.dmn.validation.dtanalysis.DMNDTAnalysisMessage;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.kie.dmn.validation.dtanalysis.model.Hyperrectangle;
import org.kie.dmn.validation.dtanalysis.model.Overlap;
import org.kie.dmn.validation.dtanalysis.utils.DTAnalysisMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDTAnalysisTest
extends AbstractValidatorTest {
    public static final Logger LOG = LoggerFactory.getLogger(AbstractDTAnalysisTest.class);

    protected static DTAnalysis getAnalysis(List<DMNMessage> dmnMessages, String id) {
        MatcherAssert.assertThat((String)"Expected to find DTAnalysis but messages are empty.", dmnMessages, (Matcher)Matchers.not((Matcher)Matchers.empty()));
        if (LOG.isDebugEnabled()) {
            LOG.debug("List<DMNMessage> dmnMessages: \n{}", (Object)ValidatorUtil.formatMessages(dmnMessages));
        }
        HashMap<String, DTAnalysis> as = new HashMap<String, DTAnalysis>();
        for (DMNMessage dmnMessage : dmnMessages) {
            if (!dmnMessage.getSourceId().equals(id) || !(dmnMessage instanceof DMNDTAnalysisMessage)) continue;
            DMNDTAnalysisMessage dmndtAnalysisMessage = (DMNDTAnalysisMessage)dmnMessage;
            if (as.containsKey(id)) {
                MatcherAssert.assertThat((String)"Inconsistency detected", (Object)((DTAnalysis)as.get(id)), (Matcher)CoreMatchers.is((Object)dmndtAnalysisMessage.getAnalysis()));
                continue;
            }
            as.put(id, dmndtAnalysisMessage.getAnalysis());
        }
        DTAnalysis analysis = (DTAnalysis)as.get(id);
        MatcherAssert.assertThat((String)"Null analysis value for key.", (Object)analysis, (Matcher)Matchers.notNullValue());
        AbstractDTAnalysisTest.debugAnalysis(analysis);
        return analysis;
    }

    protected static void debugValidatorMsg(List<DMNMessage> dmnMessages) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        StringBuilder sbGaps = new StringBuilder("Validator messages:\n");
        for (DMNMessage msg : dmnMessages) {
            sbGaps.append(String.format("%8s %s", msg.getLevel(), msg.getMessage()));
            sbGaps.append("\n");
        }
        LOG.debug(sbGaps.toString());
    }

    protected static void debugAnalysis(DTAnalysis analysis) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        StringBuilder sbGaps = new StringBuilder("\nGaps:\n");
        for (Hyperrectangle gap : analysis.getGaps()) {
            sbGaps.append(gap.toString());
            sbGaps.append("\n");
        }
        LOG.debug(sbGaps.toString());
        DefaultPrinterConfiguration printConfig = new DefaultPrinterConfiguration();
        printConfig.addOption((ConfigurationOption)new DefaultConfigurationOption(DefaultPrinterConfiguration.ConfigOption.COLUMN_ALIGN_PARAMETERS, (Object)true));
        printConfig.addOption((ConfigurationOption)new DefaultConfigurationOption(DefaultPrinterConfiguration.ConfigOption.COLUMN_ALIGN_FIRST_METHOD_CHAIN, (Object)true));
        Expression printGaps = DTAnalysisMeta.printGaps(analysis);
        LOG.debug("\n" + printGaps.toString((PrinterConfiguration)printConfig));
        StringBuilder sbOverlaps = new StringBuilder("\nOverlaps:\n");
        for (Overlap overlap : analysis.getOverlaps()) {
            sbOverlaps.append(overlap.toString());
            sbOverlaps.append("\n");
        }
        LOG.debug(sbOverlaps.toString());
        Expression printOverlaps = DTAnalysisMeta.printOverlaps(analysis);
        LOG.debug("\n" + printOverlaps.toString((PrinterConfiguration)printConfig));
    }
}

