/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.validation.AbstractValidatorTest;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.DMNValidatorFactory;
import org.kie.dmn.validation.ValidatorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorDecisionServiceTest
extends AbstractValidatorTest {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatorDecisionServiceTest.class);

    @Test
    public void testOUTPUT_NOT_FOUND_FOR_DS_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decisionservice/HelloDS_noOutput.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
            MatcherAssert.assertThat((String)((DMNMessage)validate.get(0)).toString(), (Object)((DMNMessage)validate.get(0)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.REQ_NOT_FOUND));
        }
    }

    @Test
    public void testOUTPUT_NOT_FOUND_FOR_DS_FileInput() {
        List validate = validator.validate(this.getFile("decisionservice/HelloDS_noOutput.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((String)((DMNMessage)validate.get(0)).toString(), (Object)((DMNMessage)validate.get(0)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.REQ_NOT_FOUND));
    }

    @Test
    public void testOUTPUT_NOT_FOUND_FOR_DS_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decisionservice/HelloDS_noOutput.dmn", "https://kiegroup.org/dmn/_7C3C7416-2F33-4718-AE35-F3843C5250DB", "HelloDS"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((String)((DMNMessage)validate.get(0)).toString(), (Object)((DMNMessage)validate.get(0)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.REQ_NOT_FOUND));
    }

    @Test
    public void testOKDS() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"decisionservice/HelloDS_OK.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://kiegroup.org/dmn/_7C3C7416-2F33-4718-AE35-F3843C5250DB", "HelloDS");
        MatcherAssert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Definitions definitions = dmnModel.getDefinitions();
        MatcherAssert.assertThat((Object)definitions, (Matcher)CoreMatchers.notNullValue());
        List messages = DMNValidatorFactory.newValidator().validate(definitions, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        MatcherAssert.assertThat((String)messages.toString(), (Object)messages.size(), (Matcher)CoreMatchers.is((Object)0));
        DMNResult evaluateAll = runtime.evaluateAll(dmnModel, runtime.newContext());
        LOG.debug("{}", (Object)evaluateAll);
        MatcherAssert.assertThat((Object)evaluateAll.getDecisionResultByName("Decision-1").getResult(), (Matcher)CoreMatchers.is((Object)"Hello World"));
    }

    @Test
    public void testDS1ofEach() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"decisionservice/DS1ofEach_OK.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://kiegroup.org/dmn/_40B3D02F-868C-4925-A1F2-5710DFEEF51E", "DS1ofEach");
        MatcherAssert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Definitions definitions = dmnModel.getDefinitions();
        MatcherAssert.assertThat((Object)definitions, (Matcher)CoreMatchers.notNullValue());
        List messages = DMNValidatorFactory.newValidator().validate(definitions, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        MatcherAssert.assertThat((String)messages.toString(), (Object)messages.size(), (Matcher)CoreMatchers.is((Object)0));
        DMNContext dmnContext = runtime.newContext();
        dmnContext.set("InputData-1", (Object)"id1");
        dmnContext.set("Decision-1", (Object)"od1");
        DMNResult evaluateDS1 = runtime.evaluateDecisionService(dmnModel, dmnContext, "DecisionService-1");
        LOG.debug("{}", (Object)evaluateDS1);
        MatcherAssert.assertThat((Object)evaluateDS1.getDecisionResultByName("Decision-2"), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)evaluateDS1.getDecisionResultByName("Decision-3").getResult(), (Matcher)CoreMatchers.is((Object)"d3:d2:id1od1"));
    }

    @Test
    public void testENCAPSULATED_NOT_FOUND_FOR_DS_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decisionservice/DS1ofEach_missingEncapsulated.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL});
            MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
            MatcherAssert.assertThat((String)((DMNMessage)validate.get(0)).toString(), (Object)((DMNMessage)validate.get(0)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.REQ_NOT_FOUND));
            MatcherAssert.assertThat((String)((DMNMessage)validate.get(1)).toString(), (Object)((DMNMessage)validate.get(1)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.REQ_NOT_FOUND));
        }
    }

    @Test
    public void testENCAPSULATED_NOT_FOUND_FOR_DS_FileInput() {
        List validate = validator.validate(this.getFile("decisionservice/DS1ofEach_missingEncapsulated.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL});
        MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((String)((DMNMessage)validate.get(0)).toString(), (Object)((DMNMessage)validate.get(0)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.REQ_NOT_FOUND));
        MatcherAssert.assertThat((String)((DMNMessage)validate.get(1)).toString(), (Object)((DMNMessage)validate.get(1)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.REQ_NOT_FOUND));
    }

    @Test
    public void testENCAPSULATED_NOT_FOUND_FOR_DS_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decisionservice/DS1ofEach_missingEncapsulated.dmn", "https://kiegroup.org/dmn/_40B3D02F-868C-4925-A1F2-5710DFEEF51E", "DS1ofEach"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
        MatcherAssert.assertThat((String)((DMNMessage)validate.get(0)).toString(), (Object)((DMNMessage)validate.get(0)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.REQ_NOT_FOUND));
        MatcherAssert.assertThat((String)((DMNMessage)validate.get(1)).toString(), (Object)((DMNMessage)validate.get(1)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.REQ_NOT_FOUND));
    }

    @Test
    public void testDECISIONINPUT_NOT_FOUND_FOR_DS_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decisionservice/DS1ofEach_missingDecisionInput.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL});
            MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
            MatcherAssert.assertThat((String)((DMNMessage)validate.get(0)).toString(), (Object)((DMNMessage)validate.get(0)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.REQ_NOT_FOUND));
            MatcherAssert.assertThat((String)((DMNMessage)validate.get(1)).toString(), (Object)((DMNMessage)validate.get(1)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.REQ_NOT_FOUND));
        }
    }

    @Test
    public void testDECISIONINPUT_NOT_FOUND_FOR_DS_FileInput() {
        List validate = validator.validate(this.getFile("decisionservice/DS1ofEach_missingDecisionInput.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL});
        MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((String)((DMNMessage)validate.get(0)).toString(), (Object)((DMNMessage)validate.get(0)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.REQ_NOT_FOUND));
        MatcherAssert.assertThat((String)((DMNMessage)validate.get(1)).toString(), (Object)((DMNMessage)validate.get(1)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.REQ_NOT_FOUND));
    }

    @Test
    public void testDECISIONINPUT_NOT_FOUND_FOR_DS_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decisionservice/DS1ofEach_missingDecisionInput.dmn", "https://kiegroup.org/dmn/_40B3D02F-868C-4925-A1F2-5710DFEEF51E", "DS1ofEach"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
        MatcherAssert.assertThat((String)((DMNMessage)validate.get(0)).toString(), (Object)((DMNMessage)validate.get(0)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.REQ_NOT_FOUND));
        MatcherAssert.assertThat((String)((DMNMessage)validate.get(1)).toString(), (Object)((DMNMessage)validate.get(1)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.REQ_NOT_FOUND));
    }

    @Test
    public void testINPUTDATA_NOT_FOUND_FOR_DS_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decisionservice/DS1ofEach_missingInputData.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL});
            MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
            MatcherAssert.assertThat((String)((DMNMessage)validate.get(0)).toString(), (Object)((DMNMessage)validate.get(0)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.REQ_NOT_FOUND));
            MatcherAssert.assertThat((String)((DMNMessage)validate.get(1)).toString(), (Object)((DMNMessage)validate.get(1)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.REQ_NOT_FOUND));
        }
    }

    @Test
    public void testINPUTDATA_NOT_FOUND_FOR_DS_FileInput() {
        List validate = validator.validate(this.getFile("decisionservice/DS1ofEach_missingInputData.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL});
        MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((String)((DMNMessage)validate.get(0)).toString(), (Object)((DMNMessage)validate.get(0)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.REQ_NOT_FOUND));
        MatcherAssert.assertThat((String)((DMNMessage)validate.get(1)).toString(), (Object)((DMNMessage)validate.get(1)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.REQ_NOT_FOUND));
    }

    @Test
    public void testINPUTDATA_NOT_FOUND_FOR_DS_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decisionservice/DS1ofEach_missingInputData.dmn", "https://kiegroup.org/dmn/_40B3D02F-868C-4925-A1F2-5710DFEEF51E", "DS1ofEach"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
        MatcherAssert.assertThat((String)((DMNMessage)validate.get(0)).toString(), (Object)((DMNMessage)validate.get(0)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.REQ_NOT_FOUND));
        MatcherAssert.assertThat((String)((DMNMessage)validate.get(1)).toString(), (Object)((DMNMessage)validate.get(1)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.REQ_NOT_FOUND));
    }

    @Test
    public void testOUTPUTELEMENT_NOT_FOUND_FOR_DS_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decisionservice/DS1ofEach_missingOutput.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL});
            MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
            MatcherAssert.assertThat((String)((DMNMessage)validate.get(0)).toString(), (Object)((DMNMessage)validate.get(0)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.REQ_NOT_FOUND));
        }
    }

    @Test
    public void testOUTPUTELEMENT_NOT_FOUND_FOR_DS_FileInput() {
        List validate = validator.validate(this.getFile("decisionservice/DS1ofEach_missingOutput.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL});
        MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((String)((DMNMessage)validate.get(0)).toString(), (Object)((DMNMessage)validate.get(0)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.REQ_NOT_FOUND));
    }

    @Test
    public void testOUTPUTELEMENT_NOT_FOUND_FOR_DS_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decisionservice/DS1ofEach_missingOutput.dmn", "https://kiegroup.org/dmn/_40B3D02F-868C-4925-A1F2-5710DFEEF51E", "DS1ofEach"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        MatcherAssert.assertThat((String)((DMNMessage)validate.get(0)).toString(), (Object)((DMNMessage)validate.get(0)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.REQ_NOT_FOUND));
    }
}

