/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.validation.AbstractValidatorTest;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.ValidatorUtil;

public class ValidatorDecisionTest
extends AbstractValidatorTest {
    @Test
    public void testDECISION_MISSING_EXPR() {
        List validate = validator.validate(this.getReader("decision/DECISION_MISSING_EXPR.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)((DMNMessage)validate.get(0)).toString(), (Object)((DMNMessage)validate.get(0)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.MISSING_EXPRESSION));
    }

    @Test
    public void testDECISION_MISSING_VAR() {
        List validate = validator.validate(this.getReader("decision/DECISION_MISSING_VAR.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_VARIABLE)));
    }

    @Test
    public void testDECISION_MISSING_VARbis() {
        List validate = validator.validate(this.getReader("decision/DECISION_MISSING_VARbis.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_VARIABLE)));
    }

    @Test
    public void testDECISION_MISMATCH_VAR() {
        List validate = validator.validate(this.getReader("decision/DECISION_MISMATCH_VAR.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.VARIABLE_NAME_MISMATCH)));
    }

    @Test
    public void testDECISION_MULTIPLE_EXPRESSIONS() {
        List validate = validator.validate(this.getReader("decision/DECISION_MULTIPLE_EXPRESSIONS.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.FAILED_XML_VALIDATION)));
    }

    @Test
    public void testDECISION_PERF_INDICATOR_WRONG_TYPE() {
        List validate = validator.validate(this.getReader("decision/DECISION_PERF_INDICATOR_WRONG_TYPE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
    }

    @Test
    public void testDECISION_DECISION_MAKER_WRONG_TYPE() {
        List validate = validator.validate(this.getReader("decision/DECISION_DECISION_MAKER_WRONG_TYPE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
    }

    @Test
    public void testDECISION_DECISION_OWNER_WRONG_TYPE() {
        List validate = validator.validate(this.getReader("decision/DECISION_DECISION_OWNER_WRONG_TYPE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
    }

    @Test
    public void testDECISION_CYCLIC_DEPENDENCY() {
        List validate = validator.validate(this.getReader("decision/DECISION_CYCLIC_DEPENDENCY.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
    }

    @Test
    public void testDECISION_CYCLIC_DEPENDENCY_SELF_REFERENCE() {
        List validate = validator.validate(this.getReader("decision/DECISION_CYCLIC_DEPENDENCY_SELF_REFERENCE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
    }

    @Test
    public void testDECISION_DEADLY_DIAMOND() {
        List validate = validator.validate(this.getReader("decision/DECISION_DEADLY_DIAMOND.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testDECISION_DEADLY_KITE() {
        List validate = validator.validate(this.getReader("decision/DECISION_DEADLY_KITE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)0));
    }
}

