/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.model.Contraction;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;

public class Check2ndNFViolationTest
extends AbstractDTAnalysisTest {
    @Test
    public void testCheck2ndNFViolation() {
        List validate = validator.validate(this.getReader("DT2ndNFViolation.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = Check2ndNFViolationTest.getAnalysis(validate, "_4e358bae-7012-42dd-acea-e88b3aa3c8b2");
        MatcherAssert.assertThat((Object)analysis.is2ndNFViolation(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)analysis.getContractionsViolating2ndNF(), (Matcher)Matchers.hasSize((int)1));
        Contraction c2NFViolation = (Contraction)analysis.getContractionsViolating2ndNF().iterator().next();
        MatcherAssert.assertThat((Object)c2NFViolation.rule, (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)c2NFViolation.pairedRules, (Matcher)Matchers.contains((Object[])new Integer[]{2}));
        MatcherAssert.assertThat((Object)c2NFViolation.adjacentDimension, (Matcher)Matchers.is((Object)3));
        Assert.assertTrue((String)"It should contain at DMNMessage for the 2nd NF Violation", (boolean)validate.stream().anyMatch(p -> p.getSourceId().equals("_4e358bae-7012-42dd-acea-e88b3aa3c8b2") && p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_2NDNFVIOLATION)));
    }

    @Test
    public void testCheck2ndNFViolation3combo() {
        List validate = validator.validate(this.getReader("DT2ndNF3combo.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = Check2ndNFViolationTest.getAnalysis(validate, "_BA703D04-803A-44AA-8A31-F5EEDD4FD54E");
        MatcherAssert.assertThat((Object)analysis.is2ndNFViolation(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)analysis.getContractionsViolating2ndNF(), (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void testCheck2ndNFViolationWasADash() {
        List validate = validator.validate(this.getReader("DT2ndNFWasADash.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = Check2ndNFViolationTest.getAnalysis(validate, "_C40525EF-9735-410B-A070-E0336E108268");
        MatcherAssert.assertThat((Object)analysis.is2ndNFViolation(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)analysis.getCellsViolating2ndNF(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void testCheck2ndNFViolationWasADash2() {
        List validate = validator.validate(this.getReader("DT2ndNFWasADash2.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = Check2ndNFViolationTest.getAnalysis(validate, "_D3F1D5B8-642B-446D-9099-DE4CB978CB94");
        MatcherAssert.assertThat((Object)analysis.is2ndNFViolation(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)analysis.getCellsViolating2ndNF(), (Matcher)Matchers.hasSize((int)1));
    }
}

