/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.model.Bound;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.kie.dmn.validation.dtanalysis.model.Hyperrectangle;
import org.kie.dmn.validation.dtanalysis.model.Interval;
import org.kie.dmn.validation.dtanalysis.model.Overlap;

public class OverlapsMsgTest
extends AbstractDTAnalysisTest {
    @Test
    public void test() {
        List validate = validator.validate(this.getReader("improveHF.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = OverlapsMsgTest.getAnalysis(validate, "_CA4B40F8-2354-48B6-B323-5C4E4B2CE467");
        Assertions.assertThat((Iterable)analysis.getGaps()).hasSize(0);
        Assertions.assertThat((List)analysis.getOverlaps()).hasSize(2);
        List<Overlap> overlaps = Arrays.asList(new Overlap(Arrays.asList(3, 1), new Hyperrectangle(2, Arrays.asList(Interval.newFromBounds((Bound)new Bound(Interval.NEG_INF, Range.RangeBoundary.CLOSED, null), (Bound)new Bound(Interval.POS_INF, Range.RangeBoundary.CLOSED, null)), Interval.newFromBounds((Bound)new Bound((Comparable)new BigDecimal("0"), Range.RangeBoundary.OPEN, null), (Bound)new Bound(Interval.POS_INF, Range.RangeBoundary.CLOSED, null))))), new Overlap(Arrays.asList(2, 3), new Hyperrectangle(2, Arrays.asList(Interval.newFromBounds((Bound)new Bound((Comparable)new BigDecimal("47"), Range.RangeBoundary.OPEN, null), (Bound)new Bound(Interval.POS_INF, Range.RangeBoundary.CLOSED, null)), Interval.newFromBounds((Bound)new Bound(Interval.NEG_INF, Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)new BigDecimal("0"), Range.RangeBoundary.CLOSED, null))))));
        Assertions.assertThat(overlaps).hasSize(2);
        Assertions.assertThat((List)analysis.getOverlaps()).containsAll(overlaps);
        Assertions.assertThat((String)((Overlap)analysis.getOverlaps().get(0)).getOverlap().asHumanFriendly(analysis.getDdtaTable())).isEqualTo("[ -, >0 ]");
        Assertions.assertThat((String)((Overlap)analysis.getOverlaps().get(1)).getOverlap().asHumanFriendly(analysis.getDdtaTable())).isEqualTo("[ >47, <=0 ]");
    }
}

