/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.model.Bound;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.kie.dmn.validation.dtanalysis.model.Hyperrectangle;
import org.kie.dmn.validation.dtanalysis.model.Interval;
import org.kie.dmn.validation.dtanalysis.model.MaskedRule;
import org.kie.dmn.validation.dtanalysis.model.MisleadingRule;
import org.kie.dmn.validation.dtanalysis.model.Overlap;

public class StringWithoutEnumNoGapTest
extends AbstractDTAnalysisTest {
    @Test
    public void test() {
        List validate = validator.validate(this.getReader("stringWithoutEnumNoGap.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        Assertions.assertThat((List)validate).hasSize(3);
        StringWithoutEnumNoGapTest.debugValidatorMsg(validate);
        DTAnalysis analysis = StringWithoutEnumNoGapTest.getAnalysis(validate, "_8b48d1c9-265c-47aa-9378-7f11d55dfe55");
        Assertions.assertThat((Iterable)analysis.getGaps()).hasSize(0);
        Assertions.assertThat((List)analysis.getOverlaps()).hasSize(2);
        List<Overlap> overlaps = Arrays.asList(new Overlap(Arrays.asList(1, 3), new Hyperrectangle(2, Arrays.asList(Interval.newFromBounds((Bound)new Bound((Comparable)((Object)"EU"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)((Object)"EU"), Range.RangeBoundary.CLOSED, null)), Interval.newFromBounds((Bound)new Bound((Comparable)new BigDecimal("18"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound(Interval.POS_INF, Range.RangeBoundary.CLOSED, null))))), new Overlap(Arrays.asList(3, 2), new Hyperrectangle(2, Arrays.asList(Interval.newFromBounds((Bound)new Bound((Comparable)((Object)"US"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)((Object)"US"), Range.RangeBoundary.CLOSED, null)), Interval.newFromBounds((Bound)new Bound((Comparable)new BigDecimal("21"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound(Interval.POS_INF, Range.RangeBoundary.CLOSED, null))))));
        Assertions.assertThat(overlaps).hasSize(2);
        Assertions.assertThat((List)analysis.getOverlaps()).containsAll(overlaps);
        Assertions.assertThat((List)analysis.getMaskedRules()).hasSize(2);
        List<MaskedRule> maskedRules = Arrays.asList(new MaskedRule(1, 3), new MaskedRule(2, 3));
        Assertions.assertThat(maskedRules).hasSize(2);
        Assertions.assertThat((List)analysis.getMaskedRules()).containsAll(maskedRules);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_MASKED_RULE))).as("It should contain DMNMessage for the MaskedRule", new Object[0])).isTrue();
        Assertions.assertThat((Iterable)analysis.getMisleadingRules()).hasSize(2);
        List<MisleadingRule> misleadingRules = Arrays.asList(new MisleadingRule(3, 1), new MisleadingRule(3, 2));
        Assertions.assertThat(misleadingRules).hasSize(2);
        Assertions.assertThat((Iterable)analysis.getMisleadingRules()).containsAll(misleadingRules);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)validate.stream().noneMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_MISLEADING_RULE))).as("It should NOT contain DMNMessage for the MisleadingRule", new Object[0])).isTrue();
    }
}

