/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.model.Bound;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.kie.dmn.validation.dtanalysis.model.Hyperrectangle;
import org.kie.dmn.validation.dtanalysis.model.Interval;

public class AgeKittenTest
extends AbstractDTAnalysisTest {
    @Test
    public void test_AgeKitten_domainOnTable() {
        List validate = validator.validate(this.getReader("AgeKitten-domainOnTable.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        this.checkAnalysis(validate);
    }

    @Test
    public void test_AgeKitten() {
        List validate = validator.validate(this.getReader("AgeKitten.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        this.checkAnalysis(validate);
    }

    @Test
    public void test_AgeKittenImport() throws IOException {
        try (Reader reader0 = this.getReader("AgeKittenItemDef.dmn");
             Reader reader1 = this.getReader("AgeKittenImporting.dmn");){
            List validate = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE}).theseModels(new Reader[]{reader0, reader1});
            this.checkAnalysis(validate);
        }
    }

    private void checkAnalysis(List<DMNMessage> validate) {
        DTAnalysis analysis = AgeKittenTest.getAnalysis(validate, "_5e3e4546-69c2-43f2-b93a-7ea285878ca0");
        Assertions.assertThat((Collection)analysis.getGaps()).hasSize(2);
        List<Hyperrectangle> gaps = Arrays.asList(new Hyperrectangle(2, Arrays.asList(Interval.newFromBounds((Bound)new Bound((Comparable)new BigDecimal("0"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)new BigDecimal("12"), Range.RangeBoundary.OPEN, null)))), new Hyperrectangle(2, Arrays.asList(Interval.newFromBounds((Bound)new Bound((Comparable)new BigDecimal("15"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)new BigDecimal("18"), Range.RangeBoundary.OPEN, null)), Interval.newFromBounds((Bound)new Bound((Comparable)((Object)"Dog"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)((Object)"Dog"), Range.RangeBoundary.CLOSED, null)))));
        Assertions.assertThat(gaps).hasSize(2);
        Assertions.assertThat((Collection)analysis.getGaps()).containsAll(gaps);
        Assertions.assertThat((List)analysis.getOverlaps()).hasSize(0);
    }
}

