/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.model.Bound;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.kie.dmn.validation.dtanalysis.model.Hyperrectangle;
import org.kie.dmn.validation.dtanalysis.model.Interval;

public class MultipleModelsTest
extends AbstractDTAnalysisTest {
    @Test
    public void testMultipleFromReaderInput() throws IOException {
        try (Reader reader0 = this.getReader("MyDecisionTable.dmn");
             Reader reader1 = this.getReader("tVowelDefinition.dmn");){
            List messages = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE}).theseModels(new Reader[]{reader0, reader1});
            this.checkAnalysis(messages);
        }
    }

    @Test
    public void testMultipleFromFileInput() {
        List messages = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE}).theseModels(new File[]{this.getFile("MyDecisionTable.dmn"), this.getFile("tVowelDefinition.dmn")});
        this.checkAnalysis(messages);
    }

    @Test
    public void testMultipleFromDefinitionsInput() throws IOException {
        List messages = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE}).theseModels(new Definitions[]{this.getDefinitions("MyDecisionTable.dmn", "http://www.trisotech.com/definitions/_6b77f7ac-d61a-4fb0-9e24-7ebf04444f59", "MyDecisionTable"), this.getDefinitions("tVowelDefinition.dmn", "http://www.trisotech.com/definitions/_d9beb8dd-2578-4f32-8231-cd27c199f098", "tVowelDefinition")});
        this.checkAnalysis(messages);
    }

    private void checkAnalysis(List<DMNMessage> validate) {
        DTAnalysis analysis = MultipleModelsTest.getAnalysis(validate, "_3cde04b9-d5c9-4254-9d27-436889111406");
        Assertions.assertThat((Collection)analysis.getGaps()).hasSize(1);
        List<Hyperrectangle> gaps = List.of(new Hyperrectangle(1, List.of(Interval.newFromBounds((Bound)new Bound((Comparable)((Object)"i"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)((Object)"o"), Range.RangeBoundary.OPEN, null)))));
        Assertions.assertThat(gaps).hasSize(1);
        Assertions.assertThat((Collection)analysis.getGaps()).containsAll(gaps);
        Assertions.assertThat((List)analysis.getOverlaps()).hasSize(0);
    }
}

