/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.model.api.Decision;
import org.kie.dmn.model.api.DecisionTable;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.api.HitPolicy;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;

public class RecommenderHitPolicyTest
extends AbstractDTAnalysisTest {
    @Test
    public void testGaps() {
        Definitions definitions = this.getDefinitions("RecommenderHitPolicy1.dmn", "http://www.trisotech.com/definitions/_50aea0bb-4482-48f6-acfe-4abc1a1bd0d6", "Drawing 1");
        List validate = validator.validate(definitions, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = RecommenderHitPolicyTest.getAnalysis(validate, "_3aa68aee-6314-482f-a0be-84c2411d65d7");
        RecommenderHitPolicyTest.debugValidatorMsg(validate);
        Assertions.assertThat((Collection)analysis.getGaps()).hasSize(1);
        Assertions.assertThat((boolean)validate.stream().noneMatch(m -> m.getMessageType() == DMNMessageType.DECISION_TABLE_HITPOLICY_RECOMMENDER)).isTrue();
    }

    @Test
    public void testGapsAllowNull() {
        Definitions definitions = this.getDefinitions("RecommenderHitPolicy1_allowNull.dmn", "http://www.trisotech.com/definitions/_50aea0bb-4482-48f6-acfe-4abc1a1bd0d6", "Drawing 1");
        List validate = validator.validate(definitions, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = RecommenderHitPolicyTest.getAnalysis(validate, "_3aa68aee-6314-482f-a0be-84c2411d65d7");
        RecommenderHitPolicyTest.debugValidatorMsg(validate);
        Assertions.assertThat((Collection)analysis.getGaps()).hasSize(1);
        Assertions.assertThat((boolean)validate.stream().noneMatch(m -> m.getMessageType() == DMNMessageType.DECISION_TABLE_HITPOLICY_RECOMMENDER)).isTrue();
    }

    @Test
    public void testNoGapsNoOverlaps() {
        List<HitPolicy> wrongHPs = Arrays.asList(HitPolicy.ANY, HitPolicy.PRIORITY, HitPolicy.FIRST);
        for (HitPolicy hp : wrongHPs) {
            List<DMNMessage> validate = this.getRecommenderHitPolicy2(hp);
            Assertions.assertThat((boolean)validate.stream().anyMatch(m -> m.getMessageType() == DMNMessageType.DECISION_TABLE_HITPOLICY_RECOMMENDER)).isTrue();
        }
        List<DMNMessage> validate = this.getRecommenderHitPolicy2(HitPolicy.UNIQUE);
        Assertions.assertThat((boolean)validate.stream().noneMatch(m -> m.getMessageType() == DMNMessageType.DECISION_TABLE_HITPOLICY_RECOMMENDER)).isTrue();
    }

    private List<DMNMessage> getRecommenderHitPolicy2(HitPolicy hp) {
        Definitions definitions = this.getDefinitions("RecommenderHitPolicy2.dmn", "http://www.trisotech.com/definitions/_50aea0bb-4482-48f6-acfe-4abc1a1bd0d6", "Drawing 1");
        ((DecisionTable)((Decision)definitions.getDrgElement().get(1)).getExpression()).setHitPolicy(hp);
        List validate = validator.validate(definitions, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = RecommenderHitPolicyTest.getAnalysis(validate, "_3aa68aee-6314-482f-a0be-84c2411d65d7");
        RecommenderHitPolicyTest.debugValidatorMsg(validate);
        Assertions.assertThat((Collection)analysis.getGaps()).hasSize(0);
        Assertions.assertThat((List)analysis.getOverlaps()).hasSize(0);
        return validate;
    }

    @Test
    public void testNoGapsOverlapsSameValue() {
        List<HitPolicy> wrongHPs = Arrays.asList(HitPolicy.UNIQUE, HitPolicy.PRIORITY, HitPolicy.FIRST);
        for (HitPolicy hp : wrongHPs) {
            List<DMNMessage> validate = this.getRecommenderHitPolicy3(hp);
            Assertions.assertThat((boolean)validate.stream().anyMatch(m -> m.getMessageType() == DMNMessageType.DECISION_TABLE_HITPOLICY_RECOMMENDER)).isTrue();
        }
        List<DMNMessage> validate = this.getRecommenderHitPolicy3(HitPolicy.ANY);
        Assertions.assertThat((boolean)validate.stream().noneMatch(m -> m.getMessageType() == DMNMessageType.DECISION_TABLE_HITPOLICY_RECOMMENDER)).isTrue();
    }

    private List<DMNMessage> getRecommenderHitPolicy3(HitPolicy hp) {
        Definitions definitions = this.getDefinitions("RecommenderHitPolicy3.dmn", "http://www.trisotech.com/definitions/_50aea0bb-4482-48f6-acfe-4abc1a1bd0d6", "Drawing 1");
        ((DecisionTable)((Decision)definitions.getDrgElement().get(1)).getExpression()).setHitPolicy(hp);
        List validate = validator.validate(definitions, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = RecommenderHitPolicyTest.getAnalysis(validate, "_3aa68aee-6314-482f-a0be-84c2411d65d7");
        RecommenderHitPolicyTest.debugValidatorMsg(validate);
        Assertions.assertThat((Collection)analysis.getGaps()).hasSize(0);
        Assertions.assertThat((List)analysis.getOverlaps()).hasSize(1);
        return validate;
    }

    @Test
    public void testNoGapsOverlapsDiffValue() {
        List<HitPolicy> wrongHPs = Arrays.asList(HitPolicy.UNIQUE, HitPolicy.ANY, HitPolicy.FIRST);
        for (HitPolicy hp : wrongHPs) {
            List<DMNMessage> validate = this.getRecommenderHitPolicy4(hp);
            Assertions.assertThat((boolean)validate.stream().anyMatch(m -> m.getMessageType() == DMNMessageType.DECISION_TABLE_HITPOLICY_RECOMMENDER)).isTrue();
        }
        List<DMNMessage> validate = this.getRecommenderHitPolicy4(HitPolicy.PRIORITY);
        Assertions.assertThat((boolean)validate.stream().noneMatch(m -> m.getMessageType() == DMNMessageType.DECISION_TABLE_HITPOLICY_RECOMMENDER)).isTrue();
    }

    private List<DMNMessage> getRecommenderHitPolicy4(HitPolicy hp) {
        Definitions definitions = this.getDefinitions("RecommenderHitPolicy4.dmn", "http://www.trisotech.com/definitions/_50aea0bb-4482-48f6-acfe-4abc1a1bd0d6", "Drawing 1");
        ((DecisionTable)((Decision)definitions.getDrgElement().get(1)).getExpression()).setHitPolicy(hp);
        List validate = validator.validate(definitions, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = RecommenderHitPolicyTest.getAnalysis(validate, "_3aa68aee-6314-482f-a0be-84c2411d65d7");
        RecommenderHitPolicyTest.debugValidatorMsg(validate);
        Assertions.assertThat((Collection)analysis.getGaps()).hasSize(0);
        Assertions.assertThat((List)analysis.getOverlaps()).hasSize(1);
        return validate;
    }
}

