/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis.mcdc;

import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.model.api.DecisionTable;
import org.kie.dmn.model.api.HitPolicy;
import org.kie.dmn.validation.dtanalysis.model.Bound;
import org.kie.dmn.validation.dtanalysis.model.DDTAInputEntry;
import org.kie.dmn.validation.dtanalysis.model.DDTARule;
import org.kie.dmn.validation.dtanalysis.model.DDTATable;
import org.kie.dmn.validation.dtanalysis.model.Interval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MCDCAnalyser {
    private static final Logger LOG = LoggerFactory.getLogger(MCDCAnalyser.class);
    private final DDTATable ddtaTable;
    private final DecisionTable dt;
    private Optional<Integer> elseRuleIdx = Optional.empty();
    private List<List<?>> allEnumValues = new ArrayList();
    private List<PosNegBlock> selectedBlocks = new ArrayList<PosNegBlock>();

    public MCDCAnalyser(DDTATable ddtaTable, DecisionTable dt) {
        this.ddtaTable = ddtaTable;
        this.dt = dt;
    }

    public List<PosNegBlock> compute() {
        if (this.dt.getHitPolicy() != HitPolicy.UNIQUE && this.dt.getHitPolicy() != HitPolicy.ANY && this.dt.getHitPolicy() != HitPolicy.PRIORITY) {
            return Collections.emptyList();
        }
        if (!this.ddtaTable.getColIDsStringWithoutEnum().isEmpty()) {
            return Collections.emptyList();
        }
        this.calculateElseRuleIdx();
        this.calculateAllEnumValues();
        int i = 1;
        while (this.areInputsYetToBeVisited()) {
            LOG.debug("=== Step23, iteration {}", (Object)i);
            this.step23();
            ++i;
        }
        while (!this.step4whichOutputYetToVisit().isEmpty()) {
            this.step4();
        }
        LOG.info("The final results are as follows. (marked with R the 'red color' records which are duplicates, changing input is marked with * sign)");
        LOG.info("Left Hand Side for Positive:");
        LinkedHashSet<Record> mcdcRecords = new LinkedHashSet<Record>();
        for (PosNegBlock b : this.selectedBlocks) {
            boolean add = mcdcRecords.add(b.posRecord);
            if (add) {
                LOG.info("+ {}", (Object)b.posRecord.toString(b.cMarker));
                continue;
            }
            LOG.info("R {}", (Object)b.posRecord.toString(b.cMarker));
        }
        LOG.info("Right Hand Side for Negative:");
        for (PosNegBlock b : this.selectedBlocks) {
            for (Record negRecord : b.negRecords) {
                boolean add = mcdcRecords.add(negRecord);
                if (add) {
                    LOG.info("- {}", (Object)negRecord);
                    continue;
                }
                LOG.info("R {}", (Object)negRecord);
            }
            LOG.info(" ");
        }
        LOG.info("total of cases: {}", (Object)mcdcRecords.size());
        return this.selectedBlocks;
    }

    private void step4() {
        Set<List<Comparable<?>>> outYetToVisit = this.step4whichOutputYetToVisit();
        Optional findFirst = outYetToVisit.stream().findFirst();
        if (findFirst.isEmpty()) {
            throw new IllegalArgumentException("step4 was invoked despite there are no longer output to visit.");
        }
        List pickOutToVisit = (List)findFirst.get();
        ArrayList<Integer> rules = new ArrayList<Integer>();
        for (int ruleIdx = 0; ruleIdx < this.ddtaTable.getRule().size(); ++ruleIdx) {
            if (!this.ddtaTable.getRule().get(ruleIdx).getOutputEntry().equals(pickOutToVisit)) continue;
            rules.add(ruleIdx);
        }
        LOG.trace("rules {}", rules);
        ArrayList<AbstractMap.SimpleEntry<PosNegBlock, Integer>> blocks = new ArrayList<AbstractMap.SimpleEntry<PosNegBlock, Integer>>();
        Iterator iterator = rules.iterator();
        while (iterator.hasNext()) {
            int ruleIdx = (Integer)iterator.next();
            List<Object[]> valuesForRule = this.negBlockValuesForRule(ruleIdx);
            if (valuesForRule.isEmpty()) {
                LOG.debug("step4, while looking for candidate values for rule {} I could NOT re-use from a negative case, computing new set.", (Object)ruleIdx);
                Object[] posCandidate = this.findValuesForRule(ruleIdx, Collections.unmodifiableList(this.allEnumValues));
                if (Stream.of(posCandidate).anyMatch(x -> x == null)) {
                    throw new IllegalStateException();
                }
                valuesForRule.add(posCandidate);
            }
            for (Object[] posCandidate : valuesForRule) {
                LOG.trace("ruleIdx {} values {}", (Object)(ruleIdx + 1), (Object)posCandidate);
                Record posCandidateRecord = new Record(ruleIdx, posCandidate, this.ddtaTable.getRule().get(ruleIdx).getOutputEntry());
                for (int chgInput = 0; chgInput < this.ddtaTable.getInputs().size(); ++chgInput) {
                    Optional<PosNegBlock> calculatePosNegBlock = this.calculatePosNegBlock(chgInput, posCandidate[chgInput], posCandidateRecord, Collections.unmodifiableList(this.allEnumValues));
                    if (!calculatePosNegBlock.isPresent()) continue;
                    PosNegBlock posNegBlock = calculatePosNegBlock.get();
                    int w = this.computeAdditionalWeightIntroBlock(posNegBlock);
                    LOG.trace("{} weight: {}", (Object)posNegBlock, (Object)w);
                    blocks.add(new AbstractMap.SimpleEntry<PosNegBlock, Integer>(posNegBlock, w));
                }
            }
        }
        Optional<PosNegBlock> posNegBlockFirst = blocks.stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).findFirst();
        if (posNegBlockFirst.isEmpty()) {
            throw new IllegalStateException("there is no candidable posNegBlocks.");
        }
        PosNegBlock posNegBlock = posNegBlockFirst.get();
        LOG.trace("step4 selecting block: \n{}", (Object)posNegBlock);
        this.selectBlock(posNegBlock);
    }

    private Set<List<Comparable<?>>> step4whichOutputYetToVisit() {
        Set<List<Comparable<List<Comparable<?>>>>> outYetToVisit = this.ddtaTable.getRule().stream().map(r -> r.getOutputEntry()).collect(Collectors.toSet());
        outYetToVisit.removeAll(this.getVisitedPositiveOutput());
        LOG.trace("outYetToVisit {}", outYetToVisit);
        if (outYetToVisit.size() > 1 && this.elseRuleIdx.isPresent() && outYetToVisit.contains(this.ddtaTable.getRule().get(this.elseRuleIdx.get()).getOutputEntry())) {
            LOG.trace("outYetToVisit will be filtered of the Else rule's output {}.", this.ddtaTable.getRule().get(this.elseRuleIdx.get()).getOutputEntry());
            outYetToVisit.remove(this.ddtaTable.getRule().get(this.elseRuleIdx.get()).getOutputEntry());
            LOG.trace("outYetToVisit {}", outYetToVisit);
        }
        return outYetToVisit;
    }

    private List<Object[]> negBlockValuesForRule(int ruleIdx) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (PosNegBlock b : this.selectedBlocks) {
            for (Record nr : b.negRecords) {
                if (nr.ruleIdx != ruleIdx) continue;
                result.add(nr.enums);
            }
        }
        return result;
    }

    private boolean areInputsYetToBeVisited() {
        List<Integer> idx = this.getAllColumnIndexes();
        idx.removeAll(this.getAllColumnVisited());
        return idx.size() > 0;
    }

    private void step23() {
        LOG.debug("step23() ------------------------------");
        List<Integer> visitedIndexes = this.getAllColumnVisited();
        LOG.debug("Visited Inputs: {}", this.debugListPlusOne(visitedIndexes));
        List<List<Comparable<?>>> visitedPositiveOutput = this.getVisitedPositiveOutput();
        LOG.debug("Visited positive Outputs: {}", visitedPositiveOutput);
        this.debugAllEnumValues();
        List<Integer> allIndexes = this.getAllColumnIndexes();
        allIndexes.removeAll(visitedIndexes);
        LOG.debug("Inputs yet to be analysed: {}", this.debugListPlusOne(allIndexes));
        List<Integer> idxMoreEnums = this.whichIndexHasMoreEnums(allIndexes);
        LOG.debug("2.a Pick the input with greatest number of enum values {} ? it's: {}", this.debugListPlusOne(allIndexes), this.debugListPlusOne(idxMoreEnums));
        Integer idxMostMatchingRules = idxMoreEnums.stream().map(i -> new AbstractMap.SimpleEntry<Integer, Integer>((Integer)i, this.matchingRulesForInput((int)i, this.allEnumValues.get((int)i).get(0)).size())).max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElseThrow(() -> new RuntimeException());
        LOG.debug("2.b Choose the input with the greatest number of rules matching that enum {} ? it's: {}", idxMoreEnums.stream().map(i -> new AbstractMap.SimpleEntry<Integer, Integer>((Integer)i, this.matchingRulesForInput((int)i, this.allEnumValues.get((int)i).get(0)).size())).collect(Collectors.toList()), (Object)(idxMostMatchingRules + 1));
        ArrayList<PosNegBlock> candidateBlocks = new ArrayList<PosNegBlock>();
        Object value = this.allEnumValues.get(idxMostMatchingRules).get(0);
        List<Integer> matchingRulesForInput = this.matchingRulesForInput(idxMostMatchingRules, value);
        for (int ruleIdx : matchingRulesForInput) {
            Object[] knownValues = new Object[this.ddtaTable.getInputs().size()];
            knownValues[idxMostMatchingRules.intValue()] = value;
            List<Object[]> valuesForRule = this.combinatorialValuesForRule(ruleIdx, knownValues, Collections.unmodifiableList(this.allEnumValues));
            for (Object[] posCandidate : valuesForRule) {
                List<Integer> ruleIndexesMatchingValues;
                LOG.trace("ruleIdx {} values {}", (Object)(ruleIdx + 1), (Object)posCandidate);
                if (Stream.of(posCandidate).anyMatch(x -> x == null) || !(ruleIndexesMatchingValues = this.ruleIndexesMatchingValues(posCandidate)).remove((Object)ruleIdx)) continue;
                if (ruleIndexesMatchingValues.size() > 0) {
                    LOG.debug("Skipping posCandidate {} as it could also match rules {}, besides the one currently under calculus {}", new Object[]{posCandidate, ruleIndexesMatchingValues, ruleIdx});
                    continue;
                }
                Record posCandidateRecord = new Record(ruleIdx, posCandidate, this.ddtaTable.getRule().get(ruleIdx).getOutputEntry());
                Optional<PosNegBlock> calculatePosNegBlock = this.calculatePosNegBlock(idxMostMatchingRules, value, posCandidateRecord, Collections.unmodifiableList(this.allEnumValues));
                if (!calculatePosNegBlock.isPresent()) continue;
                candidateBlocks.add(calculatePosNegBlock.get());
            }
        }
        LOG.trace("3. Input {}, initial candidate blocks \n{}", (Object)(idxMostMatchingRules + 1), candidateBlocks);
        Set filter1outs = candidateBlocks.stream().map(b -> b.posRecord.output).collect(Collectors.toSet());
        LOG.trace("filter1outs {}", filter1outs);
        if (filter1outs.stream().anyMatch(MCDCAnalyser.not(this.getVisitedPositiveOutput()::contains))) {
            LOG.trace("Trying to prioritize non-yet visited outputs...");
            HashSet hypo = new HashSet(filter1outs);
            hypo.removeAll(this.getVisitedPositiveOutput());
            if (this.elseRuleIdx.isPresent() && hypo.size() == 1 && ((List)hypo.iterator().next()).equals(this.ddtaTable.getRule().get(this.elseRuleIdx.get()).getOutputEntry())) {
                LOG.trace("...won't be prioritizing non-yet visited outputs, otherwise I would prioritize the Else rules.");
            } else {
                filter1outs.removeAll(this.getVisitedPositiveOutput());
                LOG.trace("I recomputed filter1outs to prioritize non-yet visited outputs {}", filter1outs);
            }
        }
        if (filter1outs.size() > 1 && this.elseRuleIdx.isPresent() && filter1outs.contains(this.ddtaTable.getRule().get(this.elseRuleIdx.get()).getOutputEntry())) {
            LOG.trace("filter1outs will be filtered of the Else rule's output {}.", this.ddtaTable.getRule().get(this.elseRuleIdx.get()).getOutputEntry());
            filter1outs.remove(this.ddtaTable.getRule().get(this.elseRuleIdx.get()).getOutputEntry());
            LOG.trace("filter1outs {}", filter1outs);
        }
        List filter1outsMatchingRules = filter1outs.stream().map(out -> new AbstractMap.SimpleEntry<List, Integer>((List)out, (int)this.ddtaTable.getRule().stream().filter(r -> r.getOutputEntry().equals(out)).count())).sorted(Map.Entry.comparingByValue()).collect(Collectors.toList());
        LOG.trace("3. of those blocks positive outputs, how many rule do they match? {}", filter1outsMatchingRules);
        List filter1outWithLessMatchingRules = (List)((AbstractMap.SimpleEntry)filter1outsMatchingRules.get(0)).getKey();
        LOG.trace("3. positive output of those block with the less matching rules? {}", (Object)filter1outWithLessMatchingRules);
        List filter2 = candidateBlocks.stream().filter(b -> b.posRecord.output.equals(filter1outWithLessMatchingRules)).collect(Collectors.toList());
        LOG.trace("3.FILTER-2 blocks with output corresponding to the less matching rules {}, the blocks are: \n{}", (Object)filter1outWithLessMatchingRules, filter2);
        List blockWeighted = filter2.stream().map(b -> new AbstractMap.SimpleEntry<PosNegBlock, Integer>((PosNegBlock)b, this.computeAdditionalWeightIntroBlock((PosNegBlock)b))).sorted(Map.Entry.comparingByValue()).collect(Collectors.toList());
        LOG.trace("3. blocks sorted by fewest new cases (natural weight order): \n{}", blockWeighted);
        PosNegBlock selectedBlock = (PosNegBlock)((AbstractMap.SimpleEntry)blockWeighted.get(0)).getKey();
        LOG.trace("3. I select the first, chosen block to be select: \n{}", (Object)selectedBlock);
        this.selectBlock(selectedBlock);
    }

    public static <T> Predicate<T> not(Predicate<T> t) {
        return t.negate();
    }

    private int computeAdditionalWeightIntroBlock(PosNegBlock newBlock) {
        int score = 0;
        Record posRecord = newBlock.posRecord;
        if (this.selectedBlocks.stream().noneMatch(vb -> vb.posRecord.equals(posRecord))) {
            ++score;
        }
        for (Record negRecord : newBlock.negRecords) {
            if (!this.selectedBlocks.stream().flatMap(vb -> vb.negRecords.stream()).noneMatch(nr -> nr.equals(negRecord))) continue;
            ++score;
        }
        return score;
    }

    private void selectBlock(PosNegBlock selected) {
        this.selectedBlocks.add(selected);
    }

    private List<List<Comparable<?>>> getVisitedPositiveOutput() {
        return this.selectedBlocks.stream().map(b -> b.posRecord.output).collect(Collectors.toList());
    }

    private List<Integer> getAllColumnVisited() {
        return this.selectedBlocks.stream().map(b -> b.cMarker).collect(Collectors.toList());
    }

    private List<Integer> getAllColumnIndexes() {
        return IntStream.range(0, this.ddtaTable.getInputs().size()).boxed().collect(Collectors.toList());
    }

    private List<Integer> debugListPlusOne(List<Integer> input) {
        return input.stream().map(x -> x + 1).collect(Collectors.toList());
    }

    private List<Integer> whichIndexHasMoreEnums(List<Integer> allIndexes) {
        HashMap byIndex = new HashMap();
        for (Integer idx : allIndexes) {
            byIndex.put(idx, this.allEnumValues.get(idx));
        }
        Integer max = byIndex.values().stream().map(List::size).max(Integer::compareTo).orElse(0);
        List<Integer> collect = byIndex.entrySet().stream().filter(kv -> ((List)kv.getValue()).size() == max.intValue()).map(Map.Entry::getKey).collect(Collectors.toList());
        return collect;
    }

    private Optional<PosNegBlock> calculatePosNegBlock(Integer idx, Object value, Record posCandidate, List<List<?>> allEnumValues) {
        List<Comparable<?>> posOutput = posCandidate.output;
        List<?> enumValues = allEnumValues.get(idx);
        ArrayList allOtherEnumValues = new ArrayList(enumValues);
        allOtherEnumValues.remove(value);
        ArrayList<Record> negativeRecords = new ArrayList<Record>();
        for (Object otherEnumValue : allOtherEnumValues) {
            Object[] negCandidate = Arrays.copyOf(posCandidate.enums, posCandidate.enums.length);
            negCandidate[idx.intValue()] = otherEnumValue;
            Record negRecordForNegCandidate = null;
            for (int i = 0; negRecordForNegCandidate == null && i < this.ddtaTable.getRule().size(); ++i) {
                DDTARule rule = this.ddtaTable.getRule().get(i);
                boolean ruleMatches = MCDCAnalyser.ruleMatches(rule, negCandidate);
                if (!ruleMatches) continue;
                negRecordForNegCandidate = new Record(i, negCandidate, rule.getOutputEntry());
            }
            if (negRecordForNegCandidate == null) continue;
            negativeRecords.add(negRecordForNegCandidate);
        }
        boolean allNegValuesDiffer = true;
        for (Record record : negativeRecords) {
            allNegValuesDiffer &= !record.output.equals(posOutput);
        }
        if (allNegValuesDiffer) {
            PosNegBlock posNegBlock = new PosNegBlock(idx, posCandidate, negativeRecords);
            return Optional.of(posNegBlock);
        }
        LOG.trace("For In{}={} and candidate positive of {}, it cannot be a matching rule because some negative case had SAME output {}", new Object[]{idx + 1, value, posCandidate, negativeRecords});
        return Optional.empty();
    }

    private static boolean ruleMatches(DDTARule rule, Object[] values) {
        Object cValue;
        boolean ruleMatches = true;
        for (int c = 0; ruleMatches && c < rule.getInputEntry().size(); ruleMatches &= rule.getInputEntry().get(c).getIntervals().stream().anyMatch(interval -> interval.asRangeIncludes(cValue)), ++c) {
            cValue = values[c];
        }
        return ruleMatches;
    }

    private List<Integer> ruleIndexesMatchingValues(Object[] values) {
        ArrayList<Integer> ruleIndexes = new ArrayList<Integer>();
        for (int i = 0; i < this.ddtaTable.getRule().size(); ++i) {
            DDTARule rule = this.ddtaTable.getRule().get(i);
            if (!MCDCAnalyser.ruleMatches(rule, values)) continue;
            ruleIndexes.add(i);
        }
        if (this.dt.getHitPolicy() == HitPolicy.PRIORITY) {
            ArrayList outputs = new ArrayList();
            for (Integer ruleIdx : ruleIndexes) {
                DDTARule rule = this.ddtaTable.getRule().get(ruleIdx);
                List<Comparable<?>> ruleOutput = rule.getOutputEntry();
                outputs.add(ruleOutput);
            }
            ArrayList<Comparable> computedOutput = new ArrayList<Comparable>();
            for (int i = 0; i < this.ddtaTable.getOutputs().size(); ++i) {
                List outputOrder = this.ddtaTable.getOutputs().get(i).getOutputOrder();
                int outputCursor = Integer.MAX_VALUE;
                for (List list : outputs) {
                    Comparable out = (Comparable)list.get(i);
                    if (outputOrder.indexOf(out) >= outputCursor) continue;
                    outputCursor = outputOrder.indexOf(out);
                }
                computedOutput.add((Comparable)outputOrder.get(outputCursor));
            }
            ArrayList<Integer> pIndexes = new ArrayList<Integer>();
            for (Integer ruleIdx : ruleIndexes) {
                DDTARule rule = this.ddtaTable.getRule().get(ruleIdx);
                List<Comparable<?>> list = rule.getOutputEntry();
                if (!list.equals(computedOutput)) continue;
                pIndexes.add(ruleIdx);
            }
            return pIndexes;
        }
        return ruleIndexes;
    }

    private List<Object[]> combinatorialValuesForRule(int ruleIdx, Object[] knownValues, List<List<?>> allEnumValues) {
        ArrayList result = new ArrayList();
        List<DDTAInputEntry> inputEntry = this.ddtaTable.getRule().get(ruleIdx).getInputEntry();
        ArrayList validEnumValues = new ArrayList();
        for (int i = 0; i < inputEntry.size(); ++i) {
            ArrayList<Object> enumForI = new ArrayList<Object>();
            if (knownValues[i] == null) {
                DDTAInputEntry ddtaInputEntry = inputEntry.get(i);
                List<?> enumValues = allEnumValues.get(i);
                for (Object object : enumValues) {
                    if (!ddtaInputEntry.getIntervals().stream().anyMatch(interval -> interval.asRangeIncludes(object))) continue;
                    enumForI.add(object);
                }
            } else {
                enumForI.add(knownValues[i]);
            }
            validEnumValues.add(enumForI);
        }
        ArrayList combinatorial = new ArrayList();
        combinatorial.add(new ArrayList());
        for (int i = 0; i < inputEntry.size(); ++i) {
            ArrayList combining = new ArrayList();
            for (List list : combinatorial) {
                for (Object enumForI : (List)validEnumValues.get(i)) {
                    ArrayList building = new ArrayList(list);
                    building.add(enumForI);
                    combining.add(building);
                }
            }
            combinatorial = combining;
        }
        return combinatorial.stream().map(List::toArray).collect(Collectors.toList());
    }

    private Object[] findValuesForRule(int ruleIdx, Object[] knownValues, List<List<?>> allEnumValues) {
        Object[] result = Arrays.copyOf(knownValues, knownValues.length);
        List<DDTAInputEntry> inputEntry = this.ddtaTable.getRule().get(ruleIdx).getInputEntry();
        block0: for (int i = 0; i < inputEntry.size(); ++i) {
            if (result[i] != null) continue;
            DDTAInputEntry ddtaInputEntry = inputEntry.get(i);
            List<?> enumValues = allEnumValues.get(i);
            Interval interval0 = ddtaInputEntry.getIntervals().get(0);
            if (interval0.isSingularity()) {
                result[i] = interval0.getLowerBound().getValue();
            } else if (interval0.getLowerBound().getBoundaryType() == Range.RangeBoundary.CLOSED && interval0.getLowerBound().getValue() != Interval.NEG_INF) {
                result[i] = interval0.getLowerBound().getValue();
            } else if (interval0.getUpperBound().getBoundaryType() == Range.RangeBoundary.CLOSED && interval0.getUpperBound().getValue() != Interval.POS_INF) {
                result[i] = interval0.getUpperBound().getValue();
            }
            if (!enumValues.contains(result[i])) {
                result[i] = null;
            }
            if (result[i] != null) continue;
            for (Object object : enumValues) {
                if (!ddtaInputEntry.getIntervals().stream().anyMatch(interval -> interval.asRangeIncludes(object))) continue;
                result[i] = object;
                continue block0;
            }
        }
        return result;
    }

    private Object[] findValuesForRule(int ruleIdx, List<List<?>> allEnumValues) {
        Object[] result = new Object[this.ddtaTable.getInputs().size()];
        List<DDTAInputEntry> inputEntry = this.ddtaTable.getRule().get(ruleIdx).getInputEntry();
        block0: for (int i = 0; i < inputEntry.size(); ++i) {
            if (result[i] != null) continue;
            DDTAInputEntry ddtaInputEntry = inputEntry.get(i);
            List<?> enumValues = allEnumValues.get(i);
            for (Object object : enumValues) {
                if (!ddtaInputEntry.getIntervals().stream().anyMatch(interval -> interval.asRangeIncludes(object))) continue;
                result[i] = object;
                continue block0;
            }
        }
        return result;
    }

    private List<Integer> matchingRulesForInput(int colIdx, Object value) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        List<DDTARule> rules = this.ddtaTable.getRule();
        for (int i = 0; i < rules.size(); ++i) {
            List<Interval> intervals = rules.get(i).getInputEntry().get(colIdx).getIntervals();
            if (!intervals.stream().anyMatch(interval -> interval.asRangeIncludes(value))) continue;
            results.add(i);
        }
        LOG.trace("Considering just In{}={} in the original decision tables matches rules: {} total of {} rules.", new Object[]{colIdx + 1, value, this.debugListPlusOne(results), results.size()});
        return results;
    }

    private void calculateAllEnumValues() {
        for (int idx = 0; idx < this.ddtaTable.inputCols(); ++idx) {
            if (this.ddtaTable.getInputs().get(idx).isDiscreteDomain()) {
                ArrayList discreteValues = new ArrayList(this.ddtaTable.getInputs().get(idx).getDiscreteDMNOrder());
                this.allEnumValues.add(discreteValues);
                continue;
            }
            List<Interval> colIntervals = this.ddtaTable.projectOnColumnIdx(idx);
            List bounds = colIntervals.stream().flatMap(i -> Stream.of(i.getLowerBound(), i.getUpperBound())).collect(Collectors.toList());
            Collections.sort(bounds);
            LOG.trace("bounds (sorted) {}", bounds);
            ArrayList<Object> enumValues = new ArrayList<Object>();
            Bound prevBound = (Bound)bounds.remove(0);
            while (bounds.size() > 0 && ((Bound)bounds.get(0)).compareTo(prevBound) == 0) {
                prevBound = (Bound)bounds.remove(0);
            }
            while (bounds.size() > 0) {
                Bound curBound = (Bound)bounds.remove(0);
                while (bounds.size() > 0 && ((Bound)bounds.get(0)).compareTo(curBound) == 0) {
                    curBound = (Bound)bounds.remove(0);
                }
                LOG.trace("prev {}, cur {}", (Object)prevBound, (Object)curBound);
                if (!prevBound.isUpperBound() || !curBound.isLowerBound()) {
                    if (prevBound.isUpperBound() && curBound.isUpperBound()) {
                        if (curBound.getBoundaryType() == Range.RangeBoundary.CLOSED && !this.isBoundInfinity(curBound)) {
                            enumValues.add(curBound.getValue());
                        } else {
                            LOG.trace("looking for value in-between {} {} ", (Object)prevBound, (Object)curBound);
                            enumValues.add(this.inBetween(prevBound, curBound));
                        }
                    } else if (prevBound.isLowerBound() && curBound.isLowerBound()) {
                        if (prevBound.getBoundaryType() == Range.RangeBoundary.CLOSED && !this.isBoundInfinity(prevBound)) {
                            enumValues.add(prevBound.getValue());
                        } else {
                            LOG.trace("looking for value in-between {} {} ", (Object)prevBound, (Object)curBound);
                            enumValues.add(this.inBetween(prevBound, curBound));
                        }
                    } else if (prevBound.getBoundaryType() == Range.RangeBoundary.CLOSED && !this.isBoundInfinity(prevBound)) {
                        enumValues.add(prevBound.getValue());
                    } else if (curBound.getBoundaryType() == Range.RangeBoundary.CLOSED && !this.isBoundInfinity(curBound)) {
                        enumValues.add(curBound.getValue());
                    } else {
                        LOG.trace("looking for value in-between {} {} ", (Object)prevBound, (Object)curBound);
                        enumValues.add(this.inBetween(prevBound, curBound));
                    }
                }
                prevBound = curBound;
                while (bounds.size() > 0 && ((Bound)bounds.get(0)).compareTo(prevBound) == 0) {
                    prevBound = (Bound)bounds.remove(0);
                }
            }
            LOG.trace("enumValues: {}", enumValues);
            this.allEnumValues.add(enumValues);
        }
        for (int in = 0; in < this.allEnumValues.size(); ++in) {
            int inIdx = in;
            List<?> inX = this.allEnumValues.get(in);
            List sorted = inX.stream().map(v -> new Pair((Comparable)v, this.matchingRulesForInput(inIdx, v).size())).sorted().collect(Collectors.toList());
            LOG.debug("Input {} sorted by number of matching rules: {}", (Object)(inIdx + 1), sorted);
            List sortedByMatchingRules = sorted.stream().map(Pair::getKey).collect(Collectors.toList());
            this.allEnumValues.set(inIdx, sortedByMatchingRules);
        }
        this.debugAllEnumValues();
    }

    private void debugAllEnumValues() {
        LOG.debug("allEnumValues:");
        for (int idx = 0; idx < this.allEnumValues.size(); ++idx) {
            LOG.debug("allEnumValues In{}= {}", (Object)(idx + 1), this.allEnumValues.get(idx));
        }
    }

    private void calculateElseRuleIdx() {
        if (this.dt.getHitPolicy() == HitPolicy.PRIORITY) {
            for (int ruleIdx = this.ddtaTable.getRule().size() - 1; ruleIdx >= 0 && this.elseRuleIdx.isEmpty(); --ruleIdx) {
                boolean equals;
                boolean idIDXsize1;
                DDTARule rule = this.ddtaTable.getRule().get(ruleIdx);
                List<DDTAInputEntry> ie = rule.getInputEntry();
                boolean checkAll = true;
                for (int colIdx = 0; colIdx < ie.size() && checkAll; checkAll &= idIDXsize1 && equals, ++colIdx) {
                    DDTAInputEntry ieIDX = ie.get(colIdx);
                    idIDXsize1 = ieIDX.getIntervals().size() == 1;
                    Interval ieIDXint0 = ieIDX.getIntervals().get(0);
                    Interval domainMinMax = this.ddtaTable.getInputs().get(colIdx).getDomainMinMax();
                    equals = ieIDXint0.equals(domainMinMax);
                }
                if (!checkAll) continue;
                LOG.debug("I believe P table with else rule: {}", (Object)(ruleIdx + 1));
                this.elseRuleIdx = Optional.of(ruleIdx);
            }
        }
    }

    private Object inBetween(Bound a, Bound b) {
        if (a.getValue() instanceof BigDecimal || b.getValue() instanceof BigDecimal) {
            BigDecimal guessWork;
            BigDecimal aValue = a.getValue() == Interval.NEG_INF ? ((BigDecimal)b.getValue()).add(new BigDecimal(-2)) : (BigDecimal)a.getValue();
            BigDecimal bValue = b.getValue() == Interval.POS_INF ? ((BigDecimal)a.getValue()).add(new BigDecimal(2)) : (BigDecimal)b.getValue();
            if (bValue.compareTo(guessWork = new BigDecimal(aValue.intValue() + 1)) > 0) {
                return guessWork;
            }
            if (bValue.compareTo(guessWork) == 0 && b.isLowerBound() && b.getBoundaryType() == Range.RangeBoundary.OPEN) {
                return guessWork;
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    private boolean isBoundInfinity(Bound b) {
        return b.getValue() == Interval.NEG_INF || b.getValue() == Interval.POS_INF;
    }

    public static class Pair
    implements Comparable<Pair> {
        private final Comparable key;
        private final int occurences;
        private final Comparator<Pair> c1 = Comparator.comparing(Pair::getOccurences).reversed();

        public Pair(Comparable<?> key, int occurences) {
            this.key = key;
            this.occurences = occurences;
        }

        public Comparable<?> getKey() {
            return this.key;
        }

        public int getOccurences() {
            return this.occurences;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.c1.compare(this, o) != 0) {
                return this.c1.compare(this, o);
            }
            return -1 * this.key.compareTo(o.key);
        }

        public String toString() {
            return "{" + this.key + "=" + this.occurences + "}";
        }
    }

    public static class Record {
        public final int ruleIdx;
        public final Object[] enums;
        public final List<Comparable<?>> output;

        public Record(int ruleIdx, Object[] enums, List<Comparable<?>> output) {
            this.ruleIdx = ruleIdx;
            this.enums = enums;
            this.output = output;
        }

        public String toString() {
            return String.format("%2s", this.ruleIdx + 1) + " [" + Arrays.stream(this.enums).map(Object::toString).collect(Collectors.joining("; ")) + "] -> " + this.output;
        }

        public String toString(int cMarker) {
            StringBuilder ts = new StringBuilder(String.format("%2s", this.ruleIdx + 1));
            ts.append(" [");
            for (int i = 0; i < this.enums.length; ++i) {
                if (i == cMarker) {
                    ts.append("*");
                }
                ts.append(this.enums[i]);
                if (i + 1 >= this.enums.length) continue;
                ts.append("; ");
            }
            ts.append("] -> ").append(this.output);
            return ts.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.deepHashCode(this.enums);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Record other = (Record)obj;
            return Arrays.deepEquals(this.enums, other.enums);
        }
    }

    public static class PosNegBlock {
        public final int cMarker;
        public final Record posRecord;
        public final List<Record> negRecords;

        public PosNegBlock(int cMarker, Record posRecord, List<Record> negRecords) {
            this.cMarker = cMarker;
            this.posRecord = posRecord;
            this.negRecords = negRecords;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PosNeg block In ").append(this.cMarker + 1).append("=").append(this.posRecord.enums[this.cMarker]).append("\n");
            sb.append(" + ").append(this.posRecord).append("\n");
            for (Record negRecord : this.negRecords) {
                sb.append(" - ").append(negRecord).append("\n");
            }
            return sb.toString();
        }
    }
}

